/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.cinematiccamera;

import com.equestricraft.api.common.APICinematicCameraRequestDto;
import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APILocationDto;
import com.equestricraft.api.common.APIPlayerCinematicCameraDto;
import com.equestricraft.base.location.LocationTransformer;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.core.player.cinematiccamera.PlayerCinematicCameraAccessor;
import groovy.lang.Closure;

public class APIPlayerCinematicCameraDtoImpl
implements APIPlayerCinematicCameraDto {
    private final PlayerCinematicCameraAccessor playerCinematicCameraAccessor;
    @Service
    private static LocationTransformer locationTransformer;

    public APIPlayerCinematicCameraDtoImpl(PlayerCinematicCameraAccessor playerCinematicCameraAccessor) {
        this.playerCinematicCameraAccessor = playerCinematicCameraAccessor;
    }

    @Override
    public void start(APILocationDto location, APIDurationDto duration) {
        DirectionalCoordinate coordinate = locationTransformer.fromDto(location);
        this.playerCinematicCameraAccessor.setCamera(coordinate, duration.getDuration());
    }

    @Override
    public void start(Closure<?> closure) {
        Request request = new Request();
        closure.setDelegate(request);
        closure.call();
        this.start(request.coordinate, request.duration);
    }

    private static class Request
    implements APICinematicCameraRequestDto {
        APILocationDto coordinate = new APILocationDto();
        APIDurationDto duration = new APIDurationDto();

        private Request() {
        }

        @Override
        public void location(Closure<?> closure) {
            closure.setDelegate(this.coordinate);
            closure.call();
        }

        @Override
        public void duration(Closure<?> closure) {
            closure.setDelegate(this.duration);
            closure.call();
        }
    }
}

