/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.club;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.club.CannotAddClubMemberException;
import com.equestricraft.core.club.Club;
import com.equestricraft.core.club.ClubSession;
import com.equestricraft.core.club.PlayerNotInClubException;
import com.equestricraft.core.club.member.ClubMemberSession;
import com.equestricraft.core.club.rank.ClubRank;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import java.util.Optional;

public class PlayerClubAccessor
extends AbstractPlayerAccessor {
    @Service
    private static ClubSession clubSession;
    @Service
    private static ClubMemberSession clubMemberSession;
    private final CachedValue<Club> club = new CachedValue<Club>(this::getUpdatedClub);
    private final CachedValue<ClubRank> clubRank = new CachedValue<ClubRank>(this::getUpdatedClubRank);
    private final CachedValue<Boolean> clubOwner = new CachedValue<Boolean>(this::getUpdatedClubOwner);

    public PlayerClubAccessor(CorePlayer player) {
        super(player);
    }

    public void addToClub(Club club) throws CannotAddClubMemberException {
        clubMemberSession.addClubMember(this.player, club.getId());
        this.expireCachedValues();
    }

    public void removeFromClub(Club club) throws PlayerNotInClubException {
        clubMemberSession.removeClubMember(this.player, club.getId());
        this.expireCachedValues();
    }

    public Optional<Club> getClub() {
        return Optional.ofNullable(this.club.get());
    }

    public void setRank(ClubRank clubRank) throws PlayerNotInClubException {
        clubMemberSession.setClubMembersRank(this.player, clubRank.getClubId(), clubRank.getId());
        this.expireCachedValues();
    }

    public Optional<ClubRank> getRank() {
        return Optional.ofNullable(this.clubRank.get());
    }

    public boolean isClubOwner() {
        return this.clubOwner.get();
    }

    public String getRankLabel() {
        if (this.isClubOwner()) {
            return I18n.getLabel("club.rank.owner");
        }
        return this.getRank().map(ClubRank::getName).orElse("");
    }

    public void refreshClubData() {
        this.expireCachedValues();
    }

    private Club getUpdatedClub() {
        return clubMemberSession.getPlayersClub(this.player).orElse(null);
    }

    private ClubRank getUpdatedClubRank() {
        return clubMemberSession.getPlayersClubRank(this.player).orElse(null);
    }

    private boolean getUpdatedClubOwner() {
        return clubSession.isClubOwner(this.player.getId());
    }

    private void expireCachedValues() {
        this.club.expire();
        this.clubRank.expire();
        this.clubOwner.expire();
    }
}

