/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.collectables;

import com.equestricraft.api.common.APICollectableDto;
import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIPlayerCollectableDto;
import com.equestricraft.core.collectable.APICollectableDtoImpl;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.player.collectables.PlayerCollectableAccessor;
import java.time.Duration;
import java.util.Optional;

public class APIPlayerCollectableDtoImpl
implements APIPlayerCollectableDto {
    private final Collectable collectable;
    private final PlayerCollectableAccessor playerCollectableAccessor;

    public APIPlayerCollectableDtoImpl(Collectable collectable, PlayerCollectableAccessor playerCollectableAccessor) {
        this.collectable = collectable;
        this.playerCollectableAccessor = playerCollectableAccessor;
    }

    @Override
    public APICollectableDto getCollectable() {
        return new APICollectableDtoImpl(this.collectable);
    }

    @Override
    public int getTimesFound() {
        return this.playerCollectableAccessor.getTimesCollectableFound(this.collectable.getId());
    }

    @Override
    public APIDurationDto getDurationSinceLastFound() {
        Optional<Duration> duration = this.playerCollectableAccessor.getDurationSinceLastFound(this.collectable.getId());
        return duration.map(APIDurationDto::new).orElse(null);
    }

    @Override
    public APIDurationDto getDurationSinceFirstFound() {
        Optional<Duration> duration = this.playerCollectableAccessor.getDurationSinceFirstFound(this.collectable.getId());
        return duration.map(APIDurationDto::new).orElse(null);
    }
}

