/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.collectables;

import com.equestricraft.api.common.APICollectableGroupDto;
import com.equestricraft.api.common.APIPlayerCollectableDto;
import com.equestricraft.api.common.APIPlayerCollectablesDto;
import com.equestricraft.api.common.APIPlayerFoundCollectablesDto;
import com.equestricraft.core.collectable.CannotGetCollectableException;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.collectable.group.APICollectableGroupDtoImpl;
import com.equestricraft.core.collectable.group.CollectableGroup;
import com.equestricraft.core.player.collectables.APIPlayerCollectableDtoImpl;
import com.equestricraft.core.player.collectables.APIPlayerFoundCollectablesDtoImpl;
import com.equestricraft.core.player.collectables.PlayerCollectableAccessor;
import java.util.AbstractList;
import java.util.List;

public class APIPlayerCollectablesDtoImpl
extends AbstractList<APIPlayerCollectableDto>
implements APIPlayerCollectablesDto {
    private final PlayerCollectableAccessor playerCollectableAccessor;
    private List<Collectable> allFound = null;

    public APIPlayerCollectablesDtoImpl(PlayerCollectableAccessor playerCollectableAccessor) {
        this.playerCollectableAccessor = playerCollectableAccessor;
    }

    @Override
    public boolean give(int collectableId) {
        try {
            this.playerCollectableAccessor.give(collectableId);
            return true;
        }
        catch (CannotGetCollectableException e) {
            return false;
        }
    }

    @Override
    public APIPlayerFoundCollectablesDto getFound() {
        this.ensureAllFoundLoaded();
        return new APIPlayerFoundCollectablesDtoImpl(this.playerCollectableAccessor, this.allFound);
    }

    @Override
    public boolean hasCompletedGroup(APICollectableGroupDto group) {
        CollectableGroup g = ((APICollectableGroupDtoImpl)group).getGroup();
        return this.playerCollectableAccessor.hasCompletedGroup(g);
    }

    @Override
    public APIPlayerCollectableDto get(int index) {
        this.ensureAllFoundLoaded();
        Collectable collectable = this.allFound.get(index);
        return new APIPlayerCollectableDtoImpl(collectable, this.playerCollectableAccessor);
    }

    @Override
    public int size() {
        this.ensureAllFoundLoaded();
        return this.allFound.size();
    }

    private void ensureAllFoundLoaded() {
        if (this.allFound == null) {
            this.allFound = this.playerCollectableAccessor.getAllFoundCollectables();
        }
    }
}

