/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.collectables;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.collectable.CannotGetCollectableException;
import com.equestricraft.core.collectable.Collectable;
import com.equestricraft.core.collectable.CollectableRepository;
import com.equestricraft.core.collectable.CollectableSession;
import com.equestricraft.core.collectable.FoundCollectableResponse;
import com.equestricraft.core.collectable.group.CollectableGroup;
import com.equestricraft.core.collectable.log.CollectableLogSession;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class PlayerCollectableAccessor
extends AbstractPlayerAccessor {
    @Service
    private static CollectableSession collectableSession;
    @Service
    private static CollectableLogSession collectableLogSession;
    @Service
    private static CollectableRepository collectableRepository;

    public PlayerCollectableAccessor(CorePlayer player) {
        super(player);
    }

    public FoundCollectableResponse give(int id) throws CannotGetCollectableException {
        Collectable collectable = (Collectable)collectableRepository.findByKey(id);
        return collectableSession.processCollectable(this.player, collectable);
    }

    public boolean hasFoundCollectable(int collectableId) {
        return collectableLogSession.hasPlayerFoundCollectable(this.player, collectableId);
    }

    public boolean hasFoundCollectables(List<Integer> collectableIds) {
        return collectableLogSession.hasPlayerFoundCollectables(this.player, collectableIds);
    }

    public int getTimesCollectableFound(int collectableId) {
        return collectableLogSession.getTimesPlayerHasFoundCollectable(this.player, collectableId);
    }

    public Optional<Duration> getDurationSinceLastFound(int collectableId) {
        return collectableLogSession.getDurationSincePlayerFoundCollectable(this.player, collectableId);
    }

    public Optional<Duration> getDurationSinceFirstFound(int collectableId) {
        return collectableLogSession.getDurationSinceFirstFound(this.player, collectableId);
    }

    public boolean hasCompletedGroup(CollectableGroup group) {
        return collectableSession.hasPlayerCompletedGroup(this.player, group);
    }

    public List<Collectable> getAllFoundCollectables() {
        return collectableSession.retrieveAllFoundCollectables(this.player);
    }
}

