/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.dailyjoin;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.dailyjoin.DailyJoinReward;
import com.equestricraft.core.dailyjoin.DailyJoinRewardSession;
import com.equestricraft.core.economy.EconomyUtilities;
import com.equestricraft.core.player.APIPlayerDtoImpl;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.dailyjoin.PlayerDailyJoinRewardSession;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyStandardScriptExecutor;
import com.equestricraft.logging.Log;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;

public class PlayerDailyJoinRewardSessionImpl
implements PlayerDailyJoinRewardSession {
    @Service
    private DailyJoinRewardSession dailyJoinRewardSession;
    private static final Log log = Log.getLogger(PlayerDailyJoinRewardSessionImpl.class.getName());

    @Override
    public Optional<String> processPlayerJoin(CorePlayer player) {
        int streak = player.getDailyJoinDayStreak();
        if (player.getLastDailyJoinRewardTime() != null) {
            int lastRewardDay;
            int currentDay = DateUtils.daysSince(0L);
            if (currentDay == (lastRewardDay = DateUtils.daysBetween(new Date(0L), player.getLastDailyJoinRewardTime()))) {
                return Optional.empty();
            }
            if (currentDay - lastRewardDay > 1) {
                streak = 0;
            }
        }
        Optional<String> response = this.giveDailyJoinReward(player, ++streak);
        player.setDailyJoinDayStreak(streak);
        player.setLastDailyJoinRewardTime(new Date());
        player.save();
        return response;
    }

    private Optional<String> giveDailyJoinReward(CorePlayer player, int dayStreak) {
        Optional<DailyJoinReward> reward = this.dailyJoinRewardSession.getRandomJoinReward(dayStreak);
        if (reward.isEmpty()) {
            log.warn("No daily join rewards for a day streak of {}", (Object)dayStreak);
            return Optional.empty();
        }
        DailyJoinReward r = reward.get();
        Optional<String> xpMessage = this.processXpReward(r, player);
        Optional<String> moneyMessage = this.processMoneyReward(r, player);
        Optional<String> scriptMessage = this.processScript(r, player);
        ArrayList messages = new ArrayList();
        xpMessage.ifPresent(messages::add);
        moneyMessage.ifPresent(messages::add);
        scriptMessage.ifPresent(messages::add);
        if (messages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"\n", messages));
    }

    private Optional<String> processXpReward(DailyJoinReward reward, CorePlayer player) {
        if (reward.getXpReward() > 0) {
            player.getProgression().giveXp(reward.getXpReward());
            return Optional.of("" + reward.getXpReward());
        }
        return Optional.empty();
    }

    private Optional<String> processMoneyReward(DailyJoinReward reward, CorePlayer player) {
        if (reward.getMoneyReward() > 0.0) {
            player.getEconomy().deposit(reward.getMoneyReward(), "Daily Join Reward", "Daily Join Reward");
            return Optional.of(EconomyUtilities.formatCurrency(reward.getMoneyReward()));
        }
        return Optional.empty();
    }

    private Optional<String> processScript(DailyJoinReward reward, CorePlayer player) {
        if (reward.getScript().isEmpty()) {
            return Optional.empty();
        }
        try {
            ((GroovyStandardScriptExecutor)((GroovyStandardScriptExecutor)GroovyStandardScriptExecutor.start(reward.getScript()).withPlayer(new APIPlayerDtoImpl(player))).withVariable("dayStreak", player.getDailyJoinDayStreak())).execute();
            return Optional.ofNullable(reward.getMessage());
        }
        catch (GroovyException ex) {
            log.error(String.format("Error executing daily join reward script for reward %s and player %s", reward.getId(), player.getIgn()), ex);
            return Optional.empty();
        }
    }
}

