/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.api.common.APIDiscoverLocationDto;
import com.equestricraft.api.common.APIFoundDiscoverLocationsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.discoverlocation.APIDiscoverLocationDtoImpl;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import com.equestricraft.core.discoverlocation.DiscoverLocationRepository;
import com.equestricraft.core.player.discoverlocation.PlayerDiscoverLocationAccessor;

public class APIFoundDiscoverLocationsDtoImpl
extends MapAdapter<APIDiscoverLocationDto, APIDiscoverLocationDto>
implements APIFoundDiscoverLocationsDto {
    private final PlayerDiscoverLocationAccessor playerDiscoverLocationAccessor;
    @Service
    private static DiscoverLocationRepository discoverLocationRepository;

    public APIFoundDiscoverLocationsDtoImpl(PlayerDiscoverLocationAccessor playerDiscoverLocationAccessor) {
        this.playerDiscoverLocationAccessor = playerDiscoverLocationAccessor;
    }

    @Override
    public APIDiscoverLocationDto get(Object key) {
        DiscoverLocation discoverLocation = this.getFromKey(key);
        if (this.playerDiscoverLocationAccessor.hasPlayerFoundLocation(discoverLocation.getId())) {
            return new APIDiscoverLocationDtoImpl(discoverLocation);
        }
        return null;
    }

    private DiscoverLocation getFromKey(Object key) {
        if (key instanceof APIDiscoverLocationDtoImpl) {
            APIDiscoverLocationDtoImpl dto = (APIDiscoverLocationDtoImpl)key;
            return dto.getDiscoverLocation();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (DiscoverLocation)discoverLocationRepository.findByKey(id);
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return discoverLocationRepository.findByIdentifier(identifier).orElseThrow();
        }
        throw new IllegalArgumentException("Invalid DTO");
    }
}

