/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.core.discoverlocation.DiscoverLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class CurrentLocationInfo {
    private final List<DiscoverLocation> locations;
    private final String addressString;
    private static final CurrentLocationInfo EMPTY = new CurrentLocationInfo(Collections.emptyList());

    public CurrentLocationInfo(List<DiscoverLocation> locations) {
        this.locations = locations;
        this.addressString = this.buildAddress();
    }

    private String buildAddress() {
        if (this.locations.isEmpty()) {
            return null;
        }
        List<DiscoverLocation> toShow = this.locations.stream().filter(Predicate.not(DiscoverLocation::isHideFromAddress)).toList();
        if (toShow.isEmpty()) {
            return null;
        }
        ArrayList<String> addressComponents = new ArrayList<String>(toShow.size());
        for (DiscoverLocation location : toShow) {
            addressComponents.add(location.getName());
            if (!location.isLastAddressComponent()) continue;
            break;
        }
        return String.join((CharSequence)", ", addressComponents);
    }

    public List<DiscoverLocation> getLocations() {
        return this.locations;
    }

    public Optional<DiscoverLocation> primaryLocation() {
        if (this.locations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.locations.get(0));
    }

    public DiscoverLocation requirePrimaryLocation() {
        return this.primaryLocation().orElseThrow();
    }

    public boolean isInLocation() {
        return !this.locations.isEmpty();
    }

    public Optional<String> getAddressString() {
        return Optional.ofNullable(this.addressString);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CurrentLocationInfo that = (CurrentLocationInfo)obj;
        return Objects.equals(this.locations, that.locations);
    }

    public int hashCode() {
        return Objects.hash(this.locations);
    }

    public static CurrentLocationInfo empty() {
        return EMPTY;
    }
}

