/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.compendium.CompendiumItem;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import com.equestricraft.core.discoverlocation.DiscoverLocationRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationCompendiumSession;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLog;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLogRepository;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class DiscoverLocationCompendiumSessionImpl
implements DiscoverLocationCompendiumSession {
    @Service
    private DiscoverLocationLogRepository discoverLocationLogRepository;
    @Service
    private DiscoverLocationRepository discoverLocationRepository;

    @Override
    public String getCompendiumIdentifier() {
        return "discover-locations";
    }

    @Override
    public String getCompendiumLabel() {
        return I18n.getLabel("compendium-menu.locations.title");
    }

    @Override
    public List<CompendiumItem> getCompendiumItems(ECPlayer player) {
        List<DiscoverLocationLog> playersLogs = this.discoverLocationLogRepository.findByPlayer(player.getId());
        return this.discoverLocationRepository.streamAll().filter(DiscoverLocation::isShowInCompendium).map(l -> this.buildItem((DiscoverLocation)l, playersLogs)).sorted(Comparator.comparing(CompendiumItem::getTitle)).toList();
    }

    private CompendiumItem buildItem(DiscoverLocation location, List<DiscoverLocationLog> playersLogs) {
        Date foundDate = playersLogs.stream().filter(l -> l.getLocationId() == location.getId()).findFirst().map(DiscoverLocationLog::getTimeStamp).map(Date::new).orElse(null);
        return new CompendiumItem(location.getName(), location.getDescription(), foundDate);
    }
}

