/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLog;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLogKey;
import java.util.List;

public class DiscoverLocationLogDatabase
implements RepositoryDatasource<DiscoverLocationLog, DiscoverLocationLogKey> {
    private static final String COLUMN_LOCATION_ID = "LOCATION_ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";

    @Override
    public void create(DiscoverLocationLog discoverLocationLog) {
        Query.insertInto("DISCOVER_LOCATION_LOG").columns(QueryColumn.column(COLUMN_LOCATION_ID, discoverLocationLog.getLocationId()), QueryColumn.column(COLUMN_PLAYER_ID, discoverLocationLog.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, discoverLocationLog.getTimeStamp())).execute();
    }

    @Override
    public List<DiscoverLocationLog> retrieveAll() {
        return Query.selectAllFrom("DISCOVER_LOCATION_LOG").getList(this::getFromResultRow);
    }

    private DiscoverLocationLog getFromResultRow(ResultRow row) {
        int locationId = row.getInt(COLUMN_LOCATION_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        return new DiscoverLocationLog(locationId, playerId, timeStamp);
    }
}

