/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLog;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLogDatabase;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLogKey;
import java.util.List;
import java.util.function.Function;

public class DiscoverLocationLogRepository
extends Repository<DiscoverLocationLog, DiscoverLocationLogKey> {
    @Service
    private DiscoverLocationLogDatabase discoverLocationLogDatabase;

    @Override
    protected RepositoryDatasource<DiscoverLocationLog, DiscoverLocationLogKey> getDatasource() {
        return this.discoverLocationLogDatabase;
    }

    @Override
    protected Function<DiscoverLocationLog, Object> getIndexFunction() {
        return DiscoverLocationLog::getPlayerId;
    }

    public List<DiscoverLocationLog> findLogsForByPlayerForLocations(int playerId, List<Integer> locationIds) {
        RepositorySearchQuery<DiscoverLocationLog> searchQuery = this.createSearchQuery();
        searchQuery.filter(dll -> dll.getPlayerId() == playerId);
        searchQuery.filter(dll -> locationIds.contains(dll.getLocationId()));
        return searchQuery.many();
    }

    public List<DiscoverLocationLog> findByPlayer(int playerId) {
        return this.findListByIndexKey(playerId);
    }
}

