/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.discoverlocation.CurrentLocationInfo;
import com.equestricraft.core.player.discoverlocation.PlayerDiscoverLocationSession;
import java.util.List;

public class PlayerDiscoverLocationAccessor
extends AbstractPlayerAccessor {
    private CurrentLocationInfo currentLocation = CurrentLocationInfo.empty();
    private long lastLocationCheck = System.currentTimeMillis();
    @Service
    private static PlayerDiscoverLocationSession playerDiscoverLocationSession;

    public PlayerDiscoverLocationAccessor(CorePlayer player) {
        super(player);
    }

    public CurrentLocationInfo getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(CurrentLocationInfo currentLocation) {
        this.currentLocation = currentLocation;
    }

    public boolean hasPlayerFoundLocation(int locationId) {
        return playerDiscoverLocationSession.hasPlayerFoundLocation(this.player, locationId);
    }

    public boolean hasFoundLocations(List<Integer> locationIds) {
        return locationIds.stream().allMatch(this::hasPlayerFoundLocation);
    }

    public long getMillisSinceLastLocationCheck() {
        return System.currentTimeMillis() - this.lastLocationCheck;
    }

    public void setLocationCheckPerformed() {
        this.lastLocationCheck = System.currentTimeMillis();
    }
}

