/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.discoverlocation;

import com.equestricraft.base.task.TaskScheduler;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ECLevel;
import com.equestricraft.core.discoverlocation.DiscoverLocation;
import com.equestricraft.core.discoverlocation.DiscoverLocationRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLog;
import com.equestricraft.core.player.discoverlocation.DiscoverLocationLogRepository;
import com.equestricraft.core.player.discoverlocation.LocationMoveResponse;
import com.equestricraft.core.player.discoverlocation.PlayerDiscoverLocationSession;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class PlayerDiscoverLocationSessionImpl
implements PlayerDiscoverLocationSession {
    @Service
    private DiscoverLocationRepository discoverLocationRepository;
    @Service
    private DiscoverLocationLogRepository discoverLocationLogRepository;

    @Override
    public LocationMoveResponse processLocationMove(double x, double y, double z, ECLevel level, ECPlayer player) {
        List<DiscoverLocation> locations = this.getLocationsAtLocation(x, y, z, level);
        List<DiscoverLocation> newLocationDiscoveries = this.processLocationDiscoveries(player, locations);
        return new LocationMoveResponse(locations, newLocationDiscoveries);
    }

    private List<DiscoverLocation> getLocationsAtLocation(double x, double y, double z, ECLevel level) {
        Point2D.Double point = new Point2D.Double(x, z);
        return this.findDiscoverLocationsForPoint(point, y, level);
    }

    private List<DiscoverLocation> findDiscoverLocationsForPoint(Point2D point, double y, ECLevel level) {
        List<DiscoverLocation> discoverLocationsInWorld = this.discoverLocationRepository.findEnabledLocationsByDimension(level);
        return discoverLocationsInWorld.stream().filter(l -> l.getWorldArea().getRangeY().containsValueWithin((int)y)).filter(l -> l.getWorldArea().getArea().contains(point)).sorted(Comparator.comparingInt(DiscoverLocation::getWeight).reversed()).toList();
    }

    private List<DiscoverLocation> processLocationDiscoveries(ECPlayer player, List<DiscoverLocation> currentLocations) {
        LinkedList<DiscoverLocation> newLocationDiscoveries = new LinkedList<DiscoverLocation>();
        List<Integer> currentLocationIds = currentLocations.stream().map(DiscoverLocation::getId).toList();
        List<Integer> alreadyFoundIds = this.discoverLocationLogRepository.findLogsForByPlayerForLocations(player.getId(), currentLocationIds).stream().map(DiscoverLocationLog::getLocationId).toList();
        long timeStamp = System.currentTimeMillis();
        ArrayList<Integer> xpToGive = new ArrayList<Integer>();
        for (DiscoverLocation currentLocation : currentLocations) {
            if (alreadyFoundIds.contains(currentLocation.getId())) continue;
            int xpReward = currentLocation.getXpReward();
            if (xpReward > 0) {
                xpToGive.add(xpReward);
            }
            newLocationDiscoveries.add(currentLocation);
        }
        TaskScheduler.executeAsyncTask(() -> {
            this.logNewDiscoveries(player, newLocationDiscoveries, timeStamp);
            xpToGive.forEach(xp -> player.getProgression().giveXp((int)xp));
        });
        return newLocationDiscoveries;
    }

    private void logNewDiscoveries(ECPlayer player, List<DiscoverLocation> newLocationDiscoveries, long timeStamp) {
        for (DiscoverLocation discovery : newLocationDiscoveries) {
            this.logLocationDiscovery(discovery.getId(), player, timeStamp);
        }
    }

    private void logLocationDiscovery(int id, ECPlayer player, long timeStamp) {
        DiscoverLocationLog log = new DiscoverLocationLog(id, player.getId(), timeStamp);
        this.discoverLocationLogRepository.add(log);
    }

    @Override
    public boolean hasPlayerFoundLocation(ECPlayer player, int locationId) {
        List<DiscoverLocationLog> logs = this.discoverLocationLogRepository.findLogsForByPlayerForLocations(player.getId(), Collections.singletonList(locationId));
        return !logs.isEmpty();
    }
}

