/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.donator;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.donator.DonatorService;
import com.equestricraft.logging.Log;

@TransactionManagement
public class DonatorServiceImpl
implements DonatorService {
    private static final Log log = Log.getLogger(DonatorServiceImpl.class.getName());

    @Override
    public Response setDonator(ECPlayer player) {
        return this.setDonator(player, true);
    }

    @Override
    public Response setDonator(ECPlayer player, boolean donator) {
        player.getCorePlayer().setDonator(donator);
        player.getCorePlayer().save();
        log.info("Player with internal ID {} has had donator status set to {}", (Object)player.getId(), (Object)donator);
        return ResponseFactory.success();
    }

    @Override
    public Response setDonatorLevel(ECPlayer player, DonatorLevel donatorLevel) {
        player.getCorePlayer().setDonatorLevel(donatorLevel);
        player.getCorePlayer().save();
        log.info("Player with internal ID {} has been set to the donator level of {}", (Object)player.getId(), (Object)donatorLevel.name());
        return ResponseFactory.success();
    }

    @Override
    public boolean isAtLeastDonatorLevel(ECPlayer player, DonatorLevel minimumLevel) {
        DonatorLevel playersLevel = player.getCorePlayer().getDonatorLevel();
        if (playersLevel == null) {
            return false;
        }
        return playersLevel.ordinal() >= minimumLevel.ordinal();
    }

    @Override
    public Response setClubPlus(ECPlayer player, boolean clubPlus) {
        player.getCorePlayer().setClubPlus(clubPlus);
        player.getCorePlayer().save();
        log.info("Player with internal ID {} has had club plus status set to {}", (Object)player.getId(), (Object)clubPlus);
        return ResponseFactory.success();
    }

    @Override
    public Response setGlowAccess(ECPlayer player, boolean glowAccess) {
        player.getCorePlayer().setGlowAccess(glowAccess);
        player.getCorePlayer().save();
        log.info("Player with internal ID {} has had glow access status set to {}", (Object)player.getId(), (Object)glowAccess);
        return ResponseFactory.success();
    }
}

