/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.effect;

import com.equestricraft.api.common.APIColorDto;
import com.equestricraft.api.common.APIPlayerEffectDetailsDto;
import com.equestricraft.api.common.APIPlayerEffectsDto;
import com.equestricraft.api.common.APIPlayerScreenFadeDetailsDto;
import com.equestricraft.base.ColorTransformer;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.Argb;
import com.equestricraft.core.player.effect.PlayerEffectAccessor;
import groovy.lang.Closure;
import java.time.Duration;

public class APIPlayerEffectsDtoImpl
implements APIPlayerEffectsDto {
    private final PlayerEffectAccessor playerEffectAccessor;
    @Service
    private static ColorTransformer colorTransformer;

    public APIPlayerEffectsDtoImpl(PlayerEffectAccessor playerEffectAccessor) {
        this.playerEffectAccessor = playerEffectAccessor;
    }

    @Override
    public void play(String effect, Duration duration, int amplifier) {
        this.playerEffectAccessor.playEffect(effect, duration, amplifier);
    }

    @Override
    public void play(Closure<?> config) {
        APIPlayerEffectDetailsDto details = this.buildEffectDetails(config);
        this.play(details.getEffect(), details.getDuration(), details.getAmplifier());
    }

    @Override
    public void stop(String effect) {
        this.playerEffectAccessor.stopEffect(effect);
    }

    @Override
    public void screenFade(Duration fadeIn, Duration stay, Duration fadeOut, APIColorDto color) {
        Argb argb = colorTransformer.fromDto(color);
        this.playerEffectAccessor.screenFade(fadeIn, stay, fadeOut, argb);
    }

    @Override
    public void screenFade(Closure<?> config) {
        APIPlayerScreenFadeDetailsDto details = this.buildScreenFadeDetails(config);
        this.screenFade(details.getFadeIn(), details.getStay(), details.getFadeOut(), details.getColor());
    }

    private APIPlayerEffectDetailsDto buildEffectDetails(Closure<?> closure) {
        APIPlayerEffectDetailsDto effectDetails = new APIPlayerEffectDetailsDto();
        closure.setDelegate(effectDetails);
        closure.call();
        return effectDetails;
    }

    public APIPlayerScreenFadeDetailsDto buildScreenFadeDetails(Closure<?> closure) {
        APIPlayerScreenFadeDetailsDto screenFadeDetails = new APIPlayerScreenFadeDetailsDto();
        closure.setDelegate(screenFadeDetails);
        closure.call();
        return screenFadeDetails;
    }
}

