/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.faction;

import com.equestricraft.api.common.APIFactionDto;
import com.equestricraft.api.common.APIPlayerFactionDto;
import com.equestricraft.api.common.APIPlayerFactionMembershipDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionTransformer;
import com.equestricraft.core.player.faction.APIPlayerFactionMembershipDtoImpl;
import com.equestricraft.core.player.faction.PlayerFactionAccessor;
import java.util.Optional;

public class APIPlayerFactionDtoImpl
implements APIPlayerFactionDto {
    private final PlayerFactionAccessor playerFactionAccessor;
    @Service
    private static FactionTransformer factionTransformer;

    public APIPlayerFactionDtoImpl(PlayerFactionAccessor playerFactionAccessor) {
        this.playerFactionAccessor = playerFactionAccessor;
    }

    @Override
    public APIPlayerFactionMembershipDto getMembership() {
        Optional<Faction> faction = this.playerFactionAccessor.getFaction();
        if (faction.isPresent()) {
            return new APIPlayerFactionMembershipDtoImpl(this.playerFactionAccessor);
        }
        return null;
    }

    @Override
    public void set(APIFactionDto faction) {
        Faction f = factionTransformer.fromDto(faction);
        this.playerFactionAccessor.setFaction(f);
    }

    @Override
    public void remove() {
        this.playerFactionAccessor.leaveFaction();
    }

    public String toString() {
        return this.getMembership().toString();
    }
}

