/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.faction;

import com.equestricraft.api.common.APIFactionDto;
import com.equestricraft.api.common.APIFactionRankDto;
import com.equestricraft.api.common.APIPlayerFactionMembershipDto;
import com.equestricraft.api.common.APIPlayerFactionXpDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionRank;
import com.equestricraft.core.faction.FactionTransformer;
import com.equestricraft.core.player.faction.APIPlayerFactionXpDtoImpl;
import com.equestricraft.core.player.faction.PlayerFactionAccessor;
import java.util.Optional;

public class APIPlayerFactionMembershipDtoImpl
implements APIPlayerFactionMembershipDto {
    private final PlayerFactionAccessor playerFactionAccessor;
    @Service
    private static FactionTransformer factionTransformer;

    public APIPlayerFactionMembershipDtoImpl(PlayerFactionAccessor playerFactionAccessor) {
        this.playerFactionAccessor = playerFactionAccessor;
    }

    @Override
    public APIFactionDto getFaction() {
        Optional<Faction> faction = this.playerFactionAccessor.getFaction();
        return factionTransformer.toDto(faction.orElseThrow());
    }

    @Override
    public APIFactionRankDto getRank() {
        Optional<FactionRank> rank = this.playerFactionAccessor.getRank();
        return factionTransformer.toDto(rank.orElseThrow());
    }

    @Override
    public APIPlayerFactionXpDto getXp() {
        return new APIPlayerFactionXpDtoImpl(this.playerFactionAccessor);
    }

    public String toString() {
        return this.getFaction().toString();
    }
}

