/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.faction;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionRank;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.faction.PlayerFactionSession;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.util.Optional;

public class PlayerFactionAccessor
extends AbstractPlayerAccessor {
    @Service
    private static PlayerFactionSession playerFactionSession;
    private static final DataLoadSubscriber factionUpdateSubscriber;
    private final CachedValue<Faction> faction = new CachedValue<Faction>(this::getUpdatedFaction);
    private final CachedValue<FactionRank> rank = new CachedValue<FactionRank>(this::getUpdatedRank);
    private final CachedValue<Integer> xp = new CachedValue<Integer>(this::getUpdatedXp);

    public PlayerFactionAccessor(CorePlayer player) {
        super(player);
        factionUpdateSubscriber.subscribe(this::expiredCachedValues);
    }

    private void expiredCachedValues() {
        this.faction.expire();
        this.rank.expire();
        this.xp.expire();
    }

    public Optional<Faction> getFaction() {
        return Optional.ofNullable(this.faction.get());
    }

    public Optional<FactionRank> getRank() {
        return Optional.ofNullable(this.rank.get());
    }

    public Optional<Integer> getXp() {
        return Optional.ofNullable(this.xp.get());
    }

    public void giveXp(Integer amount) {
        playerFactionSession.giveFactionXp(this.player, amount);
        this.xp.expire();
        this.rank.expire();
    }

    public void setFaction(Faction faction) {
        playerFactionSession.setPlayersFaction(this.player, faction);
        this.faction.set(faction);
    }

    public void leaveFaction() {
        playerFactionSession.removePlayerFromFaction(this.player);
    }

    private Faction getUpdatedFaction() {
        return playerFactionSession.getPlayersFaction(this.player).orElse(null);
    }

    private FactionRank getUpdatedRank() {
        return playerFactionSession.getPlayersFactionRank(this.player).orElse(null);
    }

    private Integer getUpdatedXp() {
        return playerFactionSession.getPlayersFactionXp(this.player).orElse(null);
    }

    static {
        factionUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.FACTIONS);
    }
}

