/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.faction;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.faction.Faction;
import com.equestricraft.core.faction.FactionRank;
import com.equestricraft.core.faction.FactionRepository;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.faction.PlayerFactionSession;
import java.util.Optional;

public class PlayerFactionSessionImpl
implements PlayerFactionSession {
    @Service
    private FactionRepository factionRepository;

    @Override
    public void setPlayersFaction(ECPlayer player, Faction faction) {
        CorePlayer corePlayer = player.getCorePlayer();
        corePlayer.setFactionId(faction.getId());
        corePlayer.setFactionXp(0);
        corePlayer.save();
        player.sendMessage(faction.getWelcomeMessage());
    }

    @Override
    public void removePlayerFromFaction(ECPlayer player) {
        CorePlayer corePlayer = player.getCorePlayer();
        corePlayer.setFactionId(null);
        corePlayer.setFactionXp(0);
        corePlayer.save();
    }

    @Override
    public Optional<Faction> getPlayersFaction(ECPlayer player) {
        CorePlayer corePlayer = player.getCorePlayer();
        if (corePlayer.getFactionId() == null) {
            return Optional.empty();
        }
        Faction faction = (Faction)this.factionRepository.findByKey(player.getCorePlayer().getFactionId());
        return Optional.of(faction);
    }

    @Override
    public Optional<Integer> getPlayersFactionXp(ECPlayer player) {
        CorePlayer corePlayer = player.getCorePlayer();
        if (corePlayer.getFactionId() == null) {
            return Optional.empty();
        }
        return Optional.of(corePlayer.getFactionXp());
    }

    @Override
    public void giveFactionXp(ECPlayer player, int amount) {
        CorePlayer corePlayer = player.getCorePlayer();
        int currentXp = corePlayer.getFactionXp();
        int newXp = currentXp + amount;
        corePlayer.setFactionXp(newXp);
        corePlayer.save();
    }

    @Override
    public Optional<FactionRank> getPlayersFactionRank(ECPlayer player) {
        return this.getPlayersFaction(player).map(f -> f.getRankForXp(player.getCorePlayer().getFactionXp()));
    }
}

