/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.friend;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.player.friend.PlayerFriendKey;
import java.util.Objects;

public class PlayerFriend
implements RepositoryEntity<PlayerFriendKey> {
    private final PlayerFriendKey key;
    private boolean accepted;

    public PlayerFriend(int sourcePlayerId, int targetPlayerId, boolean accepted) {
        this.key = new PlayerFriendKey(sourcePlayerId, targetPlayerId);
        this.accepted = accepted;
    }

    @Override
    public PlayerFriendKey getKey() {
        return this.key;
    }

    public int getSourcePlayerId() {
        return this.getKey().sourcePlayerId();
    }

    public int getTargetPlayerId() {
        return this.getKey().targetPlayerId();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerFriend that = (PlayerFriend)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

