/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.friend;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.friend.PlayerFriend;
import com.equestricraft.core.player.friend.PlayerFriendKey;
import java.util.List;

public class PlayerFriendDatabase
implements RepositoryDatasource<PlayerFriend, PlayerFriendKey> {
    private static final String COLUMN_SOURCE_PLAYER_ID = "SOURCE_PLAYER_ID";
    private static final String COLUMN_TARGET_PLAYER_ID = "TARGET_PLAYER_ID";
    private static final String COLUMN_ACCEPTED = "ACCEPTED";

    @Override
    public void create(PlayerFriend playerFriend) {
        Query.insertInto("PLAYER_FRIEND").columns(QueryColumn.column(COLUMN_SOURCE_PLAYER_ID, playerFriend.getSourcePlayerId()), QueryColumn.column(COLUMN_TARGET_PLAYER_ID, playerFriend.getTargetPlayerId()), QueryColumn.column(COLUMN_ACCEPTED, playerFriend.isAccepted())).execute();
    }

    @Override
    public List<PlayerFriend> retrieveAll() {
        return Query.selectAllFrom("PLAYER_FRIEND").getList(this::getFromResultRow);
    }

    private PlayerFriend getFromResultRow(ResultRow row) {
        int sourcePlayerId = row.getInt(COLUMN_SOURCE_PLAYER_ID);
        int targetPlayerId = row.getInt(COLUMN_TARGET_PLAYER_ID);
        boolean accepted = row.getBoolean(COLUMN_ACCEPTED);
        return new PlayerFriend(sourcePlayerId, targetPlayerId, accepted);
    }

    @Override
    public void update(PlayerFriend playerFriend) {
        Query.update("PLAYER_FRIEND").set(QueryColumn.column(COLUMN_ACCEPTED, playerFriend.isAccepted())).where(QueryColumn.column(COLUMN_SOURCE_PLAYER_ID, playerFriend.getSourcePlayerId()), QueryColumn.column(COLUMN_TARGET_PLAYER_ID, playerFriend.getTargetPlayerId())).execute();
    }

    @Override
    public void deleteByKey(PlayerFriendKey playerFriendKey) {
        Query.deleteFrom("PLAYER_FRIEND").where(QueryColumn.column(COLUMN_SOURCE_PLAYER_ID, playerFriendKey.sourcePlayerId()), QueryColumn.column(COLUMN_TARGET_PLAYER_ID, playerFriendKey.targetPlayerId())).execute();
    }
}

