/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.friend;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.core.player.friend.PlayerFriend;
import com.equestricraft.core.player.friend.PlayerFriendDatabase;
import com.equestricraft.core.player.friend.PlayerFriendKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class PlayerFriendRepository
extends Repository<PlayerFriend, PlayerFriendKey> {
    @Service
    private PlayerFriendDatabase playerFriendDatabase;

    @Override
    protected RepositoryDatasource<PlayerFriend, PlayerFriendKey> getDatasource() {
        return this.playerFriendDatabase;
    }

    public Optional<PlayerFriend> findFriendRecordForTwoPlayers(int player1Id, int player2Id) {
        Optional<PlayerFriend> playerFriend = this.findByKeyIfExists(new PlayerFriendKey(player1Id, player2Id));
        if (playerFriend.isPresent()) {
            return playerFriend;
        }
        return this.findByKeyIfExists(new PlayerFriendKey(player2Id, player1Id));
    }

    public List<PlayerFriend> findAllFriendRecordsWithPlayer(int playerId) {
        List<PlayerFriend> sourceRecords = this.findListByPredicates((T f) -> f.getSourcePlayerId() == playerId);
        List<PlayerFriend> targetRecords = this.findListByPredicates((T f) -> f.getTargetPlayerId() == playerId);
        return ListUtils.concatDistinct(sourceRecords, targetRecords);
    }

    public List<PlayerFriend> findIncomingRequestsForPlayer(int playerId) {
        return this.findListByPredicates(f -> f.getTargetPlayerId() == playerId, Predicate.not(PlayerFriend::isAccepted));
    }
}

