/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.friend;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.friend.PlayerFriend;
import com.equestricraft.core.player.friend.PlayerFriendException;
import com.equestricraft.core.player.friend.PlayerFriendRepository;
import com.equestricraft.core.player.friend.PlayerFriendSession;
import java.util.List;
import java.util.Optional;

public class PlayerFriendSessionImpl
implements PlayerFriendSession {
    @Service
    private PlayerFriendRepository playerFriendRepository;
    @Service
    private PlayerRepository playerRepository;

    @Override
    public void sendFriendRequest(ECPlayer sendingPlayer, ECPlayer targetPlayer) throws PlayerFriendException {
        if (sendingPlayer.equals(targetPlayer)) {
            throw new PlayerFriendException(I18n.getLabel("player.friend.cannot-friend-yourself"));
        }
        Optional<PlayerFriend> existingRecord = this.playerFriendRepository.findFriendRecordForTwoPlayers(sendingPlayer.getId(), targetPlayer.getId());
        if (existingRecord.isPresent()) {
            throw new PlayerFriendException(I18n.getLabel("player.friend.already-friends"));
        }
        PlayerFriend newRecord = new PlayerFriend(sendingPlayer.getId(), targetPlayer.getId(), false);
        this.playerFriendRepository.add(newRecord);
        targetPlayer.notify(I18n.getLabel("player.friend.request-received", sendingPlayer.getIgn()));
    }

    @Override
    public void acceptFriendRequest(ECPlayer player, ECPlayer playerToAccept) {
        PlayerFriend request = this.playerFriendRepository.findFriendRecordForTwoPlayers(player.getId(), playerToAccept.getId()).orElseThrow();
        request.setAccepted(true);
        request.save();
        playerToAccept.notify(I18n.getLabel("player.friend.player-accepted-request", player.getIgn()));
    }

    @Override
    public void denyFriendRequest(ECPlayer player, ECPlayer playerToDeny) {
        PlayerFriend request = this.playerFriendRepository.findFriendRecordForTwoPlayers(player.getId(), playerToDeny.getId()).orElseThrow();
        this.playerFriendRepository.remove(request);
    }

    @Override
    public List<CorePlayer> retrieveIncomingRequests(ECPlayer player) {
        List<PlayerFriend> incoming = this.playerFriendRepository.findIncomingRequestsForPlayer(player.getId());
        List<Integer> ids = incoming.stream().map(PlayerFriend::getSourcePlayerId).toList();
        return this.playerRepository.findByKeys(ids);
    }

    @Override
    public List<CorePlayer> retrievePlayersFriends(ECPlayer player) {
        List<PlayerFriend> friends = this.playerFriendRepository.findAllFriendRecordsWithPlayer(player.getId());
        List<Integer> ids = friends.stream().map(f -> player.getId() == f.getSourcePlayerId() ? f.getTargetPlayerId() : f.getSourcePlayerId()).toList();
        return this.playerRepository.findByKeys(ids);
    }
}

