/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.horse;

import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIPlayerHorsesDto;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.player.horse.PlayerHorseAccessor;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;

public class APIPlayerHorsesDtoImpl
extends AbstractList<APIHorseDto>
implements APIPlayerHorsesDto {
    private final PlayerHorseAccessor playerHorseAccessor;
    private List<EQHorse> allHorses = null;

    public APIPlayerHorsesDtoImpl(PlayerHorseAccessor playerHorseAccessor) {
        this.playerHorseAccessor = playerHorseAccessor;
    }

    @Override
    public List<APIHorseDto> getLiving() {
        return this.playerHorseAccessor.getLiving().stream().map(h -> new APIHorseDtoImpl((EQHorse)h)).toList();
    }

    @Override
    public Integer getLivingCount() {
        return this.playerHorseAccessor.getLiving().size();
    }

    @Override
    public APIHorseDto findByName(String name) {
        Optional<EQHorse> horse = this.playerHorseAccessor.getByName(name);
        return horse.map(APIHorseDtoImpl::new).orElse(null);
    }

    @Override
    public boolean isNameUsed(String name) {
        return this.playerHorseAccessor.isUsingName(name);
    }

    @Override
    public APIHorseDto get(int index) {
        this.ensureAllHorsesLoaded();
        EQHorse horse = this.allHorses.get(index);
        return new APIHorseDtoImpl(horse);
    }

    @Override
    public int size() {
        this.ensureAllHorsesLoaded();
        return this.allHorses.size();
    }

    private void ensureAllHorsesLoaded() {
        if (this.allHorses == null) {
            this.allHorses = this.playerHorseAccessor.getAll();
        }
    }
}

