/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.horse;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.access.HorsePlayerAccessSession;
import com.equestricraft.core.horse.name.HorseNameKey;
import com.equestricraft.core.horse.name.HorseNameService;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.horse.HorseNotSelectedException;
import com.equestricraft.core.player.horse.SelectedHorseChangeEvent;
import java.util.List;
import java.util.Optional;

public class PlayerHorseAccessor
extends AbstractPlayerAccessor {
    private EQHorse selected = null;
    private EQHorse riding = null;
    @Service
    private static HorseRepository horseRepository;
    @Service
    private static HorsePlayerAccessSession horsePlayerAccessSession;
    @Service
    private static HorseNameService horseNameService;

    public PlayerHorseAccessor(CorePlayer player) {
        super(player);
    }

    public Optional<EQHorse> getSelected() {
        return Optional.ofNullable(this.selected);
    }

    public EQHorse requiredSelected() {
        return this.getSelected().orElseThrow(HorseNotSelectedException::new);
    }

    public void setSelected(EQHorse selected) {
        if (this.selected != null && this.selected.equals(selected)) {
            return;
        }
        this.selected = selected;
        SelectedHorseChangeEvent event = new SelectedHorseChangeEvent(this.player, selected);
        ECEventBus.post(event);
        if (selected != null) {
            this.player.sendMessage(I18n.getLabel("horse.selected", selected.getName()));
        }
    }

    public void clearSelected() {
        this.setSelected(null);
    }

    public Optional<EQHorse> getRiding() {
        return Optional.ofNullable(this.riding);
    }

    public void setRiding(EQHorse riding) {
        this.riding = riding;
    }

    public List<EQHorse> getLiving() {
        return horseRepository.findLivingHorsesByOwner(this.player.getId());
    }

    public List<EQHorse> getWithAccessTo() {
        return horsePlayerAccessSession.retrieveHorsesPlayerHasAccessTo(this.player);
    }

    public List<EQHorse> getAll() {
        return horseRepository.findHorsesByOwner(this.player.getId());
    }

    public List<EQHorse> getDead() {
        return horseRepository.findDeadHorsesByOwner(this.player.getId());
    }

    public Optional<EQHorse> getByName(String name) {
        HorseNameKey key = HorseNameKey.fromStringWithDefaultPlayer(this.player, name);
        return horseNameService.findHorseByNameKey(key);
    }

    public EQHorse getHorseByName(String name) {
        HorseNameKey key = HorseNameKey.fromStringWithDefaultPlayer(this.player, name);
        return horseNameService.requireHorseByNameKey(key);
    }

    public boolean isUsingName(String name) {
        return horseNameService.isPlayerUsingName(this.player, name);
    }
}

