/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.horselogs;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseLogDto;
import com.equestricraft.api.common.APIHorseLogsSearchRequestDto;
import com.equestricraft.api.common.APIPlayerHorseLogsDto;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.horselog.HorseLogInfo;
import com.equestricraft.core.player.horselogs.PlayerHorseLogAccessor;
import groovy.lang.Closure;
import java.util.AbstractList;
import java.util.Date;
import java.util.List;

public class APIPlayerHorseLogsDtoImpl
extends AbstractList<APIHorseLogDto>
implements APIPlayerHorseLogsDto {
    private final PlayerHorseLogAccessor playerHorseLogAccessor;
    private List<HorseLogInfo> allLogs = null;

    public APIPlayerHorseLogsDtoImpl(PlayerHorseLogAccessor playerHorseLogAccessor) {
        this.playerHorseLogAccessor = playerHorseLogAccessor;
    }

    @Override
    public int getCountOfLogs(Closure<?> closure) {
        APIHorseLogsSearchRequestDto request = this.buildSearchRequest(closure);
        if (request.getPastDuration() != null) {
            return this.playerHorseLogAccessor.getCountOfLogsInPastDuration(request.getLogTypes(), request.getPastDuration().getDuration());
        }
        return this.getCountOfLogs(request.getLogTypes(), request.getSince());
    }

    @Override
    public int getCountOfLogs(List<String> logTypes, APIDurationDto pastDuration) {
        return this.playerHorseLogAccessor.getCountOfLogsInPastDuration(logTypes, pastDuration.getDuration());
    }

    @Override
    public int getCountOfLogs(List<String> logTypes, Date since) {
        return this.playerHorseLogAccessor.getCountOfLogsSince(logTypes, since);
    }

    private APIHorseLogsSearchRequestDto buildSearchRequest(Closure<?> closure) {
        APIHorseLogsSearchRequestDto request = new APIHorseLogsSearchRequestDto();
        closure.setDelegate(request);
        closure.call();
        return request;
    }

    @Override
    public APIHorseLogDto get(int index) {
        this.ensureAllLogsLoaded();
        HorseLogInfo log = this.allLogs.get(index);
        return new APIHorseLogDto(null, new APIHorseDtoImpl(log.horse()), log.time(), log.type().name(), log.message());
    }

    @Override
    public int size() {
        this.ensureAllLogsLoaded();
        return this.allLogs.size();
    }

    private void ensureAllLogsLoaded() {
        if (this.allLogs == null) {
            this.allLogs = this.playerHorseLogAccessor.getAll();
        }
    }
}

