/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.horselogs;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseLogType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.horselog.HorseLogInfo;
import com.equestricraft.core.horse.horselog.HorseLogSearchDto;
import com.equestricraft.core.horse.horselog.HorseLogSession;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class PlayerHorseLogAccessor
extends AbstractPlayerAccessor {
    @Service
    private static HorseLogSession horseLogSession;

    public PlayerHorseLogAccessor(CorePlayer player) {
        super(player);
    }

    public int getCountOfLogsInPastDuration(List<String> logTypes, Duration pastDuration) {
        return this.getCountOfLogsSince(logTypes, DateUtils.futureDurationOffset(pastDuration.negated()));
    }

    public int getCountOfLogsSince(List<String> logTypes, Date since) {
        HorseLogSearchDto search = new HorseLogSearchDto(null, this.player.getId(), this.buildLogTypesList(logTypes), since);
        return horseLogSession.getCountOfLogs(search);
    }

    private List<HorseLogType> buildLogTypesList(List<String> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return logTypes.stream().map(HorseLogType::valueOf).toList();
    }

    public List<HorseLogInfo> getAll() {
        return horseLogSession.retrieveLogsForPlayer(this.player.getId());
    }
}

