/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.inventory;

import com.equestricraft.api.common.APICoreInventoryAddRequestDto;
import com.equestricraft.api.common.APICoreInventoryDto;
import com.equestricraft.api.common.APICoreInventoryRemoveRequestDto;
import com.equestricraft.api.common.APIItemDto;
import com.equestricraft.api.common.APIPlayerCoreInventoryItemDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.item.APIItemDtoImpl;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.item.ECItemRepository;
import com.equestricraft.core.medicine.APIMedicineDtoImpl;
import com.equestricraft.core.player.inventory.APIPlayerCoreInventoryItemDtoImpl;
import com.equestricraft.core.player.inventory.PlayerInventoryAccessor;
import com.equestricraft.core.player.inventory.PlayerInventoryItemEntry;
import com.equestricraft.core.provision.APIProvisionDtoImpl;
import groovy.lang.Closure;
import java.util.AbstractList;
import java.util.List;
import java.util.UUID;

public class APICoreInventoryDtoImpl
extends AbstractList<APIPlayerCoreInventoryItemDto>
implements APICoreInventoryDto {
    private final PlayerInventoryAccessor playerInventoryAccessor;
    private List<PlayerInventoryItemEntry<?>> items = null;
    @Service
    private static ECItemRepository ecItemRepository;

    public APICoreInventoryDtoImpl(PlayerInventoryAccessor playerInventoryAccessor) {
        this.playerInventoryAccessor = playerInventoryAccessor;
    }

    @Override
    public APIPlayerCoreInventoryItemDto get(int index) {
        PlayerInventoryItemEntry<?> item = this.getItems().get(index);
        return new APIPlayerCoreInventoryItemDtoImpl(item);
    }

    private synchronized List<PlayerInventoryItemEntry<?>> getItems() {
        if (this.items == null) {
            this.items = this.playerInventoryAccessor.getItems();
        }
        return this.items;
    }

    @Override
    public int size() {
        return this.getItems().size();
    }

    @Override
    public List<UUID> add(Closure<?> config) {
        APICoreInventoryAddRequestDto request = new APICoreInventoryAddRequestDto();
        config.setDelegate(request);
        config.call();
        ECItem item = this.getItem(request.getItem());
        return this.playerInventoryAccessor.addItem(item, request.getQuantity());
    }

    @Override
    public void remove(Closure<?> config) {
        APICoreInventoryRemoveRequestDto request = new APICoreInventoryRemoveRequestDto();
        config.setDelegate(request);
        config.call();
        ECItem item = this.getItem(request.getItem());
        this.playerInventoryAccessor.removeItem(item, request.getKey(), request.getQuantity());
    }

    private ECItem getItem(APIItemDto item) {
        if (item instanceof APIItemDtoImpl) {
            APIItemDtoImpl apiItemDto = (APIItemDtoImpl)item;
            return apiItemDto.getItem();
        }
        if (item instanceof APIMedicineDtoImpl) {
            APIMedicineDtoImpl apiMedicineDto = (APIMedicineDtoImpl)item;
            return apiMedicineDto.getMedicine();
        }
        if (item instanceof APIProvisionDtoImpl) {
            APIProvisionDtoImpl apiProvisionDto = (APIProvisionDtoImpl)item;
            return apiProvisionDto.getProvision();
        }
        throw new IllegalArgumentException("Invalid item provided");
    }
}

