/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.inventory;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.core.item.ECItem;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.inventory.PlayerInventoryItemEntry;
import com.equestricraft.core.player.inventory.PlayerInventoryProvider;
import com.equestricraft.core.player.inventory.PlayerInventorySession;
import com.equestricraft.core.player.medicine.MedicineInventorySession;
import com.equestricraft.core.player.provision.ProvisionInventoryItemSession;
import com.equestricraft.core.player.tack.bonnet.HorseBonnetInventorySession;
import com.equestricraft.core.player.tack.boots.HorseBootsInventorySession;
import com.equestricraft.core.player.tack.bridle.HorseBridleInventorySession;
import com.equestricraft.core.player.tack.cinch.HorseCinchInventorySession;
import com.equestricraft.core.player.tack.girth.HorseGirthInventorySession;
import com.equestricraft.core.player.tack.halter.HorseHalterInventorySession;
import com.equestricraft.core.player.tack.pad.HorsePadInventorySession;
import com.equestricraft.core.player.tack.rein.HorseReinInventorySession;
import com.equestricraft.core.player.tack.saddle.HorseSaddleInventorySession;
import com.equestricraft.core.player.tack.wraps.HorseWrapsInventorySession;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.tack.bonnet.HorseBonnet;
import com.equestricraft.core.tack.boots.HorseBoots;
import com.equestricraft.core.tack.bridle.HorseBridle;
import com.equestricraft.core.tack.cinch.HorseCinch;
import com.equestricraft.core.tack.girth.HorseGirth;
import com.equestricraft.core.tack.halter.HorseHalter;
import com.equestricraft.core.tack.pad.HorsePad;
import com.equestricraft.core.tack.rein.HorseRein;
import com.equestricraft.core.tack.saddle.HorseSaddle;
import com.equestricraft.core.tack.wraps.HorseWraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class PlayerInventorySessionImpl
implements PlayerInventorySession {
    @Service
    private MedicineInventorySession medicineInventorySession;
    @Service
    private ProvisionInventoryItemSession provisionInventoryItemSession;
    @Service
    private HorseBonnetInventorySession horseBonnetInventorySession;
    @Service
    private HorseBootsInventorySession horseBootsInventorySession;
    @Service
    private HorseBridleInventorySession horseBridleInventorySession;
    @Service
    private HorseCinchInventorySession horseCinchInventorySession;
    @Service
    private HorseGirthInventorySession horseGirthInventorySession;
    @Service
    private HorseHalterInventorySession horseHalterInventorySession;
    @Service
    private HorsePadInventorySession horsePadInventorySession;
    @Service
    private HorseReinInventorySession horseReinInventorySession;
    @Service
    private HorseSaddleInventorySession horseSaddleInventorySession;
    @Service
    private HorseWrapsInventorySession horseWrapsInventorySession;
    @Service
    private ServiceInstance<PlayerInventoryProvider> playerInventoryProviders;

    @Override
    public List<UUID> addItemToInventory(ECPlayer player, ECItem item, int quantity) {
        if (item instanceof Medicine) {
            Medicine medicine = (Medicine)item;
            this.medicineInventorySession.addItemToInventory(player, medicine, quantity);
            return Collections.singletonList(UUID.randomUUID());
        }
        if (item instanceof Provision) {
            Provision provision = (Provision)item;
            return this.provisionInventoryItemSession.addItemToInventory(player, provision, quantity);
        }
        if (item instanceof HorseBonnet) {
            HorseBonnet horseBonnet = (HorseBonnet)item;
            return this.horseBonnetInventorySession.addItemToInventory(player, horseBonnet, quantity);
        }
        if (item instanceof HorseBoots) {
            HorseBoots horseBoots = (HorseBoots)item;
            return this.horseBootsInventorySession.addItemToInventory(player, horseBoots, quantity);
        }
        if (item instanceof HorseBridle) {
            HorseBridle horseBridle = (HorseBridle)item;
            return this.horseBridleInventorySession.addItemToInventory(player, horseBridle, quantity);
        }
        if (item instanceof HorseCinch) {
            HorseCinch horseCinch = (HorseCinch)item;
            return this.horseCinchInventorySession.addItemToInventory(player, horseCinch, quantity);
        }
        if (item instanceof HorseGirth) {
            HorseGirth horseGirth = (HorseGirth)item;
            return this.horseGirthInventorySession.addItemToInventory(player, horseGirth, quantity);
        }
        if (item instanceof HorseHalter) {
            HorseHalter horseHalter = (HorseHalter)item;
            return this.horseHalterInventorySession.addItemToInventory(player, horseHalter, quantity);
        }
        if (item instanceof HorsePad) {
            HorsePad horsePad = (HorsePad)item;
            return this.horsePadInventorySession.addItemToInventory(player, horsePad, quantity);
        }
        if (item instanceof HorseRein) {
            HorseRein horseRein = (HorseRein)item;
            return this.horseReinInventorySession.addItemToInventory(player, horseRein, quantity);
        }
        if (item instanceof HorseSaddle) {
            HorseSaddle horseSaddle = (HorseSaddle)item;
            return this.horseSaddleInventorySession.addItemToInventory(player, horseSaddle, quantity);
        }
        if (item instanceof HorseWraps) {
            HorseWraps horseWraps = (HorseWraps)item;
            return this.horseWrapsInventorySession.addItemToInventory(player, horseWraps, quantity);
        }
        throw new IllegalArgumentException(String.format("Invalid item: %s", item.getClass().getName()));
    }

    @Override
    public void removeItemFromInventory(ECPlayer player, ECItem item, UUID key, int quantity) {
        if (item instanceof Medicine) {
            Medicine medicine = (Medicine)item;
            this.medicineInventorySession.removeItemFromInventory(player, medicine, quantity);
        } else if (item instanceof Provision) {
            this.provisionInventoryItemSession.removeItemFromInventory(key, quantity);
        } else if (item instanceof HorseBonnet) {
            this.horseBonnetInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseBoots) {
            this.horseBootsInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseBridle) {
            this.horseBridleInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseCinch) {
            this.horseCinchInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseGirth) {
            this.horseGirthInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseHalter) {
            this.horseHalterInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorsePad) {
            this.horsePadInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseRein) {
            this.horseReinInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseSaddle) {
            this.horseSaddleInventorySession.removeItemFromInventory(key);
        } else if (item instanceof HorseWraps) {
            this.horseWrapsInventorySession.removeItemFromInventory(key);
        } else {
            throw new IllegalArgumentException(String.format("Invalid item: %s", item.getClass().getName()));
        }
    }

    @Override
    public List<PlayerInventoryItemEntry<?>> retrievePlayersInventory(ECPlayer player) {
        ArrayList allItems = new ArrayList(0);
        for (PlayerInventoryProvider provider : this.playerInventoryProviders) {
            List items = provider.retrieveItemsForPlayer(player);
            allItems.addAll(items);
        }
        return allItems;
    }
}

