/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.api.common.APIJobDto;
import com.equestricraft.api.common.APIJobRankDto;
import com.equestricraft.api.common.APIPlayerJobMembershipDto;
import com.equestricraft.api.common.APIPlayerJobXpDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.job.APIPlayerCurrentJobXpDtoImpl;
import com.equestricraft.core.player.job.PlayerJobAccessor;

public class APIPlayerCurrentJobMembershipDto
implements APIPlayerJobMembershipDto {
    private final PlayerJobAccessor playerJobAccessor;
    @Service
    private static JobTransformer jobTransformer;

    public APIPlayerCurrentJobMembershipDto(PlayerJobAccessor playerJobAccessor) {
        this.playerJobAccessor = playerJobAccessor;
    }

    @Override
    public APIJobDto getJob() {
        Job job = this.playerJobAccessor.getCurrent().orElseThrow();
        return jobTransformer.toApiDto(job);
    }

    @Override
    public APIJobRankDto getRank() {
        JobRank rank = this.playerJobAccessor.getRank().orElseThrow();
        return jobTransformer.toApiDto(rank);
    }

    @Override
    public APIPlayerJobXpDto getXp() {
        return new APIPlayerCurrentJobXpDtoImpl(this.playerJobAccessor);
    }

    @Override
    public boolean isFinishedInduction() {
        return this.playerJobAccessor.hasFinishedInductionMode();
    }

    @Override
    public void setFinishedInduction(boolean finished) {
        this.playerJobAccessor.setFinishedInduction(finished);
    }

    public String toString() {
        return this.getJob().toString();
    }
}

