/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.api.common.APIJobDto;
import com.equestricraft.api.common.APIJobRankDto;
import com.equestricraft.api.common.APIPlayerJobMembershipDto;
import com.equestricraft.api.common.APIPlayerJobXpDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSession;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.job.APIPlayerPreviousJobXpDtoImpl;
import com.equestricraft.core.player.job.PlayerJob;

public class APIPlayerPreviousJobMembershipDto
implements APIPlayerJobMembershipDto {
    private final PlayerJob playerJob;
    @Service
    private static JobSession jobSession;
    @Service
    private static JobRepository jobRepository;
    @Service
    private static JobTransformer jobTransformer;

    public APIPlayerPreviousJobMembershipDto(PlayerJob playerJob) {
        this.playerJob = playerJob;
    }

    @Override
    public APIJobDto getJob() {
        Job job = (Job)jobRepository.findByKey(this.playerJob.getJobId());
        return jobTransformer.toApiDto(job);
    }

    @Override
    public APIJobRankDto getRank() {
        JobRank jobRank = jobSession.getJobsRankForXp(this.playerJob.getJobId(), this.playerJob.getXp());
        return jobTransformer.toApiDto(jobRank);
    }

    @Override
    public APIPlayerJobXpDto getXp() {
        return new APIPlayerPreviousJobXpDtoImpl(this.playerJob.getXp());
    }

    @Override
    public boolean isFinishedInduction() {
        return this.playerJob.getFinishedInductionDate() != null;
    }

    @Override
    public void setFinishedInduction(boolean finished) {
        throw new UnsupportedOperationException("Cannot finish the induction for a job a player is not in");
    }
}

