/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.job.PlayerJobKey;
import com.equestricraft.core.player.job.PlayerJobRepository;
import java.util.Date;
import java.util.Objects;

public class PlayerJob
implements RepositoryEntity<PlayerJobKey> {
    private final PlayerJobKey key;
    private final Date firstHireDate;
    private Date finishedInductionDate;
    private Date lastInJob;
    private boolean manager;
    private int xp;

    public PlayerJob(int playerId, int jobId, Date firstHireDate, Date finishedInductionDate, Date lastInJob, boolean manager, int xp) {
        this.key = new PlayerJobKey(playerId, jobId);
        this.firstHireDate = firstHireDate;
        this.finishedInductionDate = finishedInductionDate;
        this.lastInJob = lastInJob;
        this.manager = manager;
        this.xp = xp;
    }

    @Override
    public PlayerJobKey getKey() {
        return this.key;
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getJobId() {
        return this.getKey().jobId();
    }

    public Date getFirstHireDate() {
        return this.firstHireDate;
    }

    public Date getFinishedInductionDate() {
        return this.finishedInductionDate;
    }

    public void setFinishedInductionDate(Date finishedInductionDate) {
        this.finishedInductionDate = finishedInductionDate;
    }

    public Date getLastInJob() {
        return this.lastInJob;
    }

    public void setLastInJob(Date lastInJob) {
        this.lastInJob = lastInJob;
    }

    public boolean isManager() {
        return this.manager;
    }

    public void setManager(boolean manager) {
        this.manager = manager;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    @Override
    public void save() {
        Services.getService(PlayerJobRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerJob that = (PlayerJob)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

