/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.job.PlayerJob;
import com.equestricraft.core.player.job.PlayerJobSession;
import com.equestricraft.core.player.job.PlayerJobXpService;
import com.equestricraft.core.player.job.PlayerNotInJobException;
import com.equestricraft.core.player.job.work.JobWorkAccessor;
import com.equestricraft.dataload.DataLoadModule;
import com.equestricraft.dataload.DataLoadSubscriber;
import java.util.Optional;

public class PlayerJobAccessor
extends AbstractPlayerAccessor {
    @Service
    private static PlayerJobSession playerJobSession;
    @Service
    private static PlayerJobXpService playerJobXpService;
    private static final DataLoadSubscriber jobUpdateSubscriber;
    private final CachedValue<Job> job = new CachedValue<Job>(this::getUpdatedJob);
    private final CachedValue<JobRank> rank = new CachedValue<JobRank>(this::getUpdatedJobRank);
    private final CachedValue<Integer> xp = new CachedValue<Integer>(this::getUpdatedXp);
    private final JobWorkAccessor jobWorkAccessor;

    public PlayerJobAccessor(CorePlayer player) {
        super(player);
        this.jobWorkAccessor = new JobWorkAccessor(player);
        jobUpdateSubscriber.subscribe(this::expireCachedValues);
    }

    private void expireCachedValues() {
        this.job.expire();
        this.rank.expire();
        this.xp.expire();
    }

    public Optional<Job> getCurrent() {
        return Optional.ofNullable(this.job.get());
    }

    public boolean setCurrent(Job job) {
        boolean removed = playerJobSession.setPlayersJob(this.player, job);
        if (removed) {
            this.expireCachedValues();
        }
        return removed;
    }

    public void removeFromJob(Job job) throws PlayerNotInJobException {
        playerJobSession.removePlayersJob(this.player, job);
        this.expireCachedValues();
    }

    public Optional<JobRank> getRank() {
        return Optional.ofNullable(this.rank.get());
    }

    public Optional<Integer> getXp() {
        return Optional.ofNullable(this.xp.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int giveXp(Integer amount) {
        try {
            int n = playerJobSession.giveJobXpToPlayer(this.player, this.player.getJobId(), amount);
            return n;
        }
        catch (PlayerNotInJobException ignored) {
            int n = 0;
            return n;
        }
        finally {
            this.xp.expire();
            this.rank.expire();
        }
    }

    public boolean hasFinishedInductionMode() {
        try {
            return playerJobSession.hasPlayerFinishedJobInduction(this.player);
        }
        catch (PlayerNotInJobException ignored) {
            return false;
        }
    }

    public void setFinishedInduction(boolean finished) {
        try {
            playerJobSession.setPlayerFinishedInduction(this.player, this.player.getJobId());
        }
        catch (PlayerNotInJobException playerNotInJobException) {
            // empty catch block
        }
    }

    public Optional<PlayerJob> getMembership(int jobId) {
        return playerJobSession.getPlayersJobMembership(this.player, jobId);
    }

    public JobWorkAccessor getWork() {
        return this.jobWorkAccessor;
    }

    private Job getUpdatedJob() {
        return playerJobSession.getPlayersJob(this.player).orElse(null);
    }

    private JobRank getUpdatedJobRank() {
        return playerJobSession.getPlayersJobRank(this.player).orElse(null);
    }

    private Integer getUpdatedXp() {
        return playerJobXpService.getPlayersXpForCurrentJob(this.player).orElse(null);
    }

    static {
        jobUpdateSubscriber = new DataLoadSubscriber(DataLoadModule.JOBS);
    }
}

