/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.job.PlayerJob;
import com.equestricraft.core.player.job.PlayerJobKey;
import java.sql.Date;
import java.util.List;

public class PlayerJobDatabase
implements RepositoryDatasource<PlayerJob, PlayerJobKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_JOB_ID = "JOB_ID";
    private static final String COLUMN_FIRST_HIRE_DATE = "FIRST_HIRE_DATE";
    private static final String COLUMN_FINISHED_INDUCTION_DATE = "FINISHED_INDUCTION_DATE";
    private static final String COLUMN_LAST_IN_JOB = "LAST_IN_JOB";
    private static final String COLUMN_MANAGER = "MANAGER";
    private static final String COLUMN_XP = "XP";

    @Override
    public void create(PlayerJob playerJob) {
        Query.insertInto("PLAYER_JOB").columns(QueryColumn.column(COLUMN_PLAYER_ID, playerJob.getPlayerId()), QueryColumn.column(COLUMN_JOB_ID, playerJob.getJobId()), QueryColumn.column(COLUMN_FIRST_HIRE_DATE, playerJob.getFirstHireDate()), QueryColumn.column(COLUMN_FINISHED_INDUCTION_DATE, playerJob.getFinishedInductionDate()), QueryColumn.column(COLUMN_LAST_IN_JOB, playerJob.getLastInJob()), QueryColumn.column(COLUMN_MANAGER, playerJob.isManager()), QueryColumn.column(COLUMN_XP, playerJob.getXp())).execute();
    }

    @Override
    public List<PlayerJob> retrieveAll() {
        return Query.selectAllFrom("PLAYER_JOB").getList(this::getFromResultRow);
    }

    private PlayerJob getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int jobId = row.getInt(COLUMN_JOB_ID);
        Date firstHireDate = row.getDate(COLUMN_FIRST_HIRE_DATE);
        Date finishedInductionDate = row.getNullableDate(COLUMN_FINISHED_INDUCTION_DATE);
        Date lastInJob = row.getNullableDate(COLUMN_LAST_IN_JOB);
        boolean manager = row.getBoolean(COLUMN_MANAGER);
        int xp = row.getInt(COLUMN_XP);
        return new PlayerJob(playerId, jobId, firstHireDate, finishedInductionDate, lastInJob, manager, xp);
    }

    @Override
    public void update(PlayerJob playerJob) {
        Query.update("PLAYER_JOB").set(QueryColumn.column(COLUMN_FINISHED_INDUCTION_DATE, playerJob.getFinishedInductionDate()), QueryColumn.column(COLUMN_XP, playerJob.getXp()), QueryColumn.column(COLUMN_MANAGER, playerJob.isManager()), QueryColumn.column(COLUMN_LAST_IN_JOB, playerJob.getLastInJob())).where(QueryColumn.column(COLUMN_PLAYER_ID, playerJob.getPlayerId()), QueryColumn.column(COLUMN_JOB_ID, playerJob.getJobId())).execute();
    }
}

