/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.job.Job;
import com.equestricraft.core.job.JobRepository;
import com.equestricraft.core.job.JobSession;
import com.equestricraft.core.job.JobTransformer;
import com.equestricraft.core.job.jobrank.JobRank;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.job.PlayerJob;
import com.equestricraft.core.player.job.PlayerJobDto;
import com.equestricraft.core.player.job.PlayerJobRepository;
import com.equestricraft.core.player.job.PlayerJobSession;
import com.equestricraft.core.player.job.PlayerNotInJobException;
import com.equestricraft.discord.roles.DiscordRoleUpdater;
import java.util.Date;
import java.util.Optional;

public class PlayerJobSessionImpl
implements PlayerJobSession {
    @Service
    private PlayerJobRepository playerJobRepository;
    @Service
    private JobSession jobSession;
    @Service
    private JobRepository jobRepository;
    @Service
    private JobTransformer jobTransformer;
    private final DiscordRoleUpdater discordRoleUpdater = new DiscordRoleUpdater();

    @Override
    public boolean setPlayersJob(CorePlayer player, Job job) {
        if (this.isPlayerInAnyJob(player)) {
            return false;
        }
        player.setJobId(job.getId());
        player.save();
        this.checkPlayersJobMembership(player, job.getId());
        if (job.getDiscordRoleId() != null) {
            this.discordRoleUpdater.giveRoleToPlayer(player.getId(), job.getDiscordRoleId());
        }
        return true;
    }

    private void checkPlayersJobMembership(ECPlayer player, int jobId) {
        if (!this.doesPlayerHaveMembershipForJob(player, jobId)) {
            this.initialisePlayersJobMembership(player, jobId);
        }
    }

    @Override
    public void removePlayersJob(CorePlayer player, Job job) throws PlayerNotInJobException {
        if (!this.isPlayerInJob(player, job.getId())) {
            throw new PlayerNotInJobException(I18n.getLabel("job.not-in-job"));
        }
        player.setJobId(null);
        player.save();
        this.setPlayerLastInJob(player, job.getId());
        if (job.getDiscordRoleId() != null) {
            this.discordRoleUpdater.takeRoleFromPlayer(player.getId(), job.getDiscordRoleId());
        }
    }

    private void setPlayerLastInJob(ECPlayer player, int jobId) throws PlayerNotInJobException {
        PlayerJob playerJob = this.getPlayersJobMembership(player, jobId).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        playerJob.setLastInJob(new Date());
        playerJob.save();
    }

    @Override
    public Optional<PlayerJobDto> getPlayersJobMembership(ECPlayer player) {
        if (player.getCorePlayer().getJobId() == null) {
            return Optional.empty();
        }
        Job job = this.getPlayersJob(player.getCorePlayer()).orElseThrow();
        PlayerJob playersJob = this.getPlayersJobMembership(player, job.getId()).orElseThrow();
        JobRank jobRank = this.jobSession.getJobsRankForXp(job.getId(), playersJob.getXp());
        return Optional.of(new PlayerJobDto(this.jobTransformer.toSimple(job), playersJob.getFirstHireDate(), playersJob.getLastInJob(), playersJob.isManager(), this.jobTransformer.toSimple(jobRank), playersJob.getXp(), playersJob.getFinishedInductionDate() != null));
    }

    @Override
    public Optional<Job> getPlayersJob(CorePlayer player) {
        if (player.getJobId() == null) {
            return Optional.empty();
        }
        Job job = (Job)this.jobRepository.findByKey(player.getJobId());
        return Optional.of(job);
    }

    @Override
    public Optional<JobRank> getPlayersJobRank(CorePlayer player) {
        if (player.getJobId() == null) {
            return Optional.empty();
        }
        PlayerJob playersJob = this.getPlayersJobMembership(player, player.getJobId()).orElseThrow();
        JobRank rank = this.jobSession.getJobsRankForXp(playersJob.getJobId(), playersJob.getXp());
        return Optional.of(rank);
    }

    @Override
    public boolean isPlayerInJob(ECPlayer player, int jobId) {
        Integer currentJobId = player.getCorePlayer().getJobId();
        return currentJobId != null && currentJobId == jobId;
    }

    @Override
    public boolean isPlayerInAnyJob(ECPlayer player) {
        return player.getCorePlayer().getJobId() != null;
    }

    @Override
    public int getPlayersMoneyBoostPercentageForCurrentJob(ECPlayer player) {
        JobRank jobRank = this.jobSession.getJobsRankForXp(player.getCorePlayer().getJobId(), player.getProgression().getXp());
        return jobRank.getMoneyBoostPercentage();
    }

    @Override
    public int getPlayersXpBoostPercentageForCurrentJob(ECPlayer player) {
        JobRank jobRank = this.jobSession.getJobsRankForXp(player.getCorePlayer().getJobId(), player.getProgression().getXp());
        return jobRank.getPlayerXpBoostPercentage();
    }

    @Override
    public void syncPlayersJobDiscordRole(ECPlayer player) {
        Job job;
        Optional<Job> playersJob = this.getPlayersJob(player.getCorePlayer());
        if (playersJob.isPresent() && (job = playersJob.get()).getDiscordRoleId() != null) {
            this.discordRoleUpdater.giveRoleToPlayer(player.getId(), job.getDiscordRoleId());
        }
    }

    private void initialisePlayersJobMembership(ECPlayer player, int jobId) {
        PlayerJob playerJob = new PlayerJob(player.getId(), jobId, new Date(), null, null, false, 0);
        this.playerJobRepository.add(playerJob);
        Job job = (Job)this.jobRepository.findByKey(jobId);
        if (job.getParentJobId() != null) {
            this.initialisePlayersJobMembership(player, job.getParentJobId());
        }
    }

    @Override
    public void setPlayerFinishedInduction(ECPlayer player, int jobId) throws PlayerNotInJobException {
        PlayerJob playerJob = this.getPlayersJobMembership(player, jobId).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        playerJob.setFinishedInductionDate(new Date());
        playerJob.save();
    }

    @Override
    public void resetPlayerJobInduction(ECPlayer player, int jobId) throws PlayerNotInJobException {
        PlayerJob playerJob = this.getPlayersJobMembership(player, jobId).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        playerJob.setFinishedInductionDate(null);
        playerJob.save();
    }

    @Override
    public boolean hasPlayerFinishedJobInduction(ECPlayer player) throws PlayerNotInJobException {
        PlayerJobDto playerJob = this.getPlayersJobMembership(player.getCorePlayer()).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        return playerJob.finishedInduction();
    }

    @Override
    public int giveJobXpToPlayer(ECPlayer player, int jobId, int xp) throws PlayerNotInJobException {
        PlayerJob playerJob = this.getPlayersJobMembership(player, jobId).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        int newXp = playerJob.getXp() + xp;
        playerJob.setXp(newXp);
        playerJob.save();
        Job job = (Job)this.jobRepository.findByKey(jobId);
        if (job.getParentJobId() != null) {
            Job parentJob = (Job)this.jobRepository.findByKey(job.getParentJobId());
            this.giveJobXpToPlayer(player, parentJob.getParentJobId(), xp);
        }
        return newXp;
    }

    @Override
    public Optional<PlayerJob> getPlayersJobMembership(ECPlayer player, int jobId) {
        return this.playerJobRepository.findXpByPlayerAndJob(player.getId(), jobId);
    }

    private boolean doesPlayerHaveMembershipForJob(ECPlayer player, int jobId) {
        return this.getPlayersJobMembership(player, jobId).isPresent();
    }

    @Override
    public boolean isPlayerJobManager(ECPlayer player, int jobId) {
        return this.getPlayersJobMembership(player, jobId).map(PlayerJob::isManager).orElse(false);
    }

    @Override
    public void setPlayerJobManager(ECPlayer player, int jobId, boolean jobManager) throws PlayerNotInJobException {
        PlayerJob playerJob = this.getPlayersJobMembership(player, jobId).orElseThrow(() -> new PlayerNotInJobException(I18n.getLabel("job.not-in-job")));
        playerJob.setManager(jobManager);
        playerJob.save();
    }

    @Override
    public boolean hasPlayerEverHadJob(ECPlayer player) {
        return !this.playerJobRepository.findByPlayer(player.getId()).isEmpty();
    }
}

