/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.job;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.job.PlayerJob;
import com.equestricraft.core.player.job.PlayerJobSession;
import com.equestricraft.core.player.job.PlayerJobXpService;
import java.util.Optional;

public class PlayerJobXpServiceImpl
implements PlayerJobXpService {
    @Service
    private PlayerJobSession playerJobSession;

    @Override
    public Response givePlayerJobXp(ECPlayer player, int xp) {
        if (player.getCorePlayer().getJobId() == null) {
            return ResponseFactory.fail(I18n.getLabel("job.not-in-any-job"));
        }
        int newAmount = player.getJob().giveXp(xp);
        return ResponseFactory.success(I18n.getLabel("job.xp-given", xp, newAmount));
    }

    @Override
    public Optional<Integer> getPlayersXPForJob(ECPlayer player, int jobId) {
        return this.playerJobSession.getPlayersJobMembership(player, jobId).map(PlayerJob::getXp);
    }

    @Override
    public Optional<Integer> getPlayersXpForCurrentJob(ECPlayer player) {
        if (player.getCorePlayer().getJobId() == null) {
            return Optional.empty();
        }
        return this.getPlayersXPForJob(player, player.getCorePlayer().getJobId());
    }
}

