/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.medicine;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.medicine.MedicineInventoryItemKey;
import com.equestricraft.core.player.medicine.MedicineInventoryItemRepository;
import java.util.Objects;

public class MedicineInventoryItem
implements RepositoryEntity<MedicineInventoryItemKey> {
    private final MedicineInventoryItemKey key;
    private int quantity;

    public MedicineInventoryItem(int playerId, int medicineId, int quantity) {
        this.key = new MedicineInventoryItemKey(playerId, medicineId);
        this.quantity = quantity;
    }

    @Override
    public MedicineInventoryItemKey getKey() {
        return this.key;
    }

    public int getPlayerId() {
        return this.getKey().playerId();
    }

    public int getMedicineId() {
        return this.getKey().medicineId();
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    @Override
    public void save() {
        Services.getService(MedicineInventoryItemRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MedicineInventoryItem that = (MedicineInventoryItem)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }
}

