/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.medicine;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.medicine.MedicineInventoryItem;
import com.equestricraft.core.player.medicine.MedicineInventoryItemKey;
import java.util.List;

public class MedicineInventoryItemDatabase
implements RepositoryDatasource<MedicineInventoryItem, MedicineInventoryItemKey> {
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_MEDICINE_ID = "MEDICINE_ID";
    private static final String COLUMN_QUANTITY = "QUANTITY";

    @Override
    public void create(MedicineInventoryItem medicineInventoryItem) {
        Query.insertInto("MEDICINE_INVENTORY_ITEM").columns(QueryColumn.column(COLUMN_PLAYER_ID, medicineInventoryItem.getPlayerId()), QueryColumn.column(COLUMN_MEDICINE_ID, medicineInventoryItem.getMedicineId()), QueryColumn.column(COLUMN_QUANTITY, medicineInventoryItem.getQuantity())).execute();
    }

    @Override
    public List<MedicineInventoryItem> retrieveAll() {
        return Query.selectAllFrom("MEDICINE_INVENTORY_ITEM").getList(this::getFromResultRow);
    }

    private MedicineInventoryItem getFromResultRow(ResultRow row) {
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        int medicineId = row.getInt(COLUMN_MEDICINE_ID);
        int quantity = row.getInt(COLUMN_QUANTITY);
        return new MedicineInventoryItem(playerId, medicineId, quantity);
    }

    @Override
    public void update(MedicineInventoryItem medicineInventoryItem) {
        Query.update("MEDICINE_INVENTORY_ITEM").set(QueryColumn.column(COLUMN_QUANTITY, medicineInventoryItem.getQuantity())).where(QueryColumn.column(COLUMN_PLAYER_ID, medicineInventoryItem.getPlayerId()), QueryColumn.column(COLUMN_MEDICINE_ID, medicineInventoryItem.getMedicineId())).execute();
    }

    @Override
    public void deleteByKey(MedicineInventoryItemKey medicineInventoryItemKey) {
        Query.deleteFrom("MEDICINE_INVENTORY_ITEM").where(QueryColumn.column(COLUMN_PLAYER_ID, medicineInventoryItemKey.playerId()), QueryColumn.column(COLUMN_MEDICINE_ID, medicineInventoryItemKey.medicineId())).execute();
    }
}

