/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.medicine;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.medicine.MedicineInventoryItem;
import com.equestricraft.core.player.medicine.MedicineInventoryItemDatabase;
import com.equestricraft.core.player.medicine.MedicineInventoryItemKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class MedicineInventoryItemRepository
extends Repository<MedicineInventoryItem, MedicineInventoryItemKey> {
    @Service
    private MedicineInventoryItemDatabase medicineInventoryItemDatabase;

    @Override
    protected RepositoryDatasource<MedicineInventoryItem, MedicineInventoryItemKey> getDatasource() {
        return this.medicineInventoryItemDatabase;
    }

    @Override
    protected Function<MedicineInventoryItem, Object> getIndexFunction() {
        return MedicineInventoryItem::getPlayerId;
    }

    public List<MedicineInventoryItem> findByPlayer(int playerId) {
        return this.findListByIndexKey(playerId);
    }

    public Optional<MedicineInventoryItem> findByPlayerAndMedicine(int playerId, int medicineId) {
        return this.findByKeyIfExists(new MedicineInventoryItemKey(playerId, medicineId));
    }
}

