/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.medicine;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineInfo;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.medicine.MedicineTransformer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.medicine.MedicineInventoryItem;
import com.equestricraft.core.player.medicine.MedicineInventoryItemInfo;
import com.equestricraft.core.player.medicine.MedicineInventoryItemRepository;
import com.equestricraft.core.player.medicine.MedicineInventorySession;
import java.util.List;
import java.util.Optional;

public class MedicineInventorySessionImpl
implements MedicineInventorySession {
    @Service
    private MedicineInventoryItemRepository medicineInventoryItemRepository;
    @Service
    private MedicineRepository medicineRepository;
    @Service
    private MedicineTransformer medicineTransformer;

    @Override
    public void addItemToInventory(ECPlayer player, Medicine medicine, int quantity) {
        Optional<MedicineInventoryItem> existing = this.medicineInventoryItemRepository.findByPlayerAndMedicine(player.getId(), medicine.getId());
        if (existing.isPresent()) {
            int newQuantity = existing.get().getQuantity() + quantity;
            existing.get().setQuantity(newQuantity);
            existing.get().save();
        } else {
            MedicineInventoryItem newItem = new MedicineInventoryItem(player.getId(), medicine.getId(), quantity);
            this.medicineInventoryItemRepository.add(newItem);
        }
    }

    @Override
    public void removeItemFromInventory(ECPlayer player, Medicine medicine, int quantity) {
        Optional<MedicineInventoryItem> existing = this.medicineInventoryItemRepository.findByPlayerAndMedicine(player.getId(), medicine.getId());
        if (existing.isPresent()) {
            int newQuantity = existing.get().getQuantity() - quantity;
            if (newQuantity <= 0) {
                this.medicineInventoryItemRepository.remove(existing.get());
            } else {
                existing.get().setQuantity(newQuantity);
                existing.get().save();
            }
        }
    }

    @Override
    public List<MedicineInventoryItemInfo> retrieveListOfMedicinesItemsPlayerHas(ECPlayer player) {
        List<MedicineInventoryItem> playersMedicine = this.medicineInventoryItemRepository.findByPlayer(player.getId());
        List<Integer> medicineIds = playersMedicine.stream().map(MedicineInventoryItem::getMedicineId).toList();
        List medicines = this.medicineRepository.findByKeys(medicineIds);
        return playersMedicine.stream().map(item -> {
            Medicine medicine = medicines.stream().filter(m -> m.getId() == item.getMedicineId()).findFirst().orElseThrow();
            MedicineInfo info2 = this.medicineTransformer.toInfo(medicine);
            return new MedicineInventoryItemInfo(info2, item.getQuantity());
        }).toList();
    }
}

