/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.medicine;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.inventory.PlayerInventoryProvider;
import com.equestricraft.core.player.medicine.MedicineInventoryItem;
import com.equestricraft.core.player.medicine.MedicineInventoryItemEntry;
import com.equestricraft.core.player.medicine.MedicineInventoryItemRepository;
import java.util.List;

public class PlayerMedicineInventoryProvider
implements PlayerInventoryProvider<MedicineInventoryItemEntry> {
    @Service
    private MedicineInventoryItemRepository medicineInventoryItemRepository;
    @Service
    private MedicineRepository medicineRepository;

    @Override
    public List<MedicineInventoryItemEntry> retrieveItemsForPlayer(ECPlayer player) {
        List<MedicineInventoryItem> playersMedicine = this.medicineInventoryItemRepository.findByPlayer(player.getId());
        List<Integer> medicineIds = playersMedicine.stream().map(MedicineInventoryItem::getMedicineId).toList();
        List medicines = this.medicineRepository.findByKeys(medicineIds);
        return playersMedicine.stream().map(item -> {
            Medicine medicine = medicines.stream().filter(m -> m.getId() == item.getMedicineId()).findFirst().orElseThrow();
            return new MedicineInventoryItemEntry(medicine, item.getQuantity());
        }).toList();
    }
}

