/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.message;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.AbstractPlayerAccessor;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import java.util.Optional;

public class PrivateMessageAccessor
extends AbstractPlayerAccessor {
    private ECPlayer lastMessagedPlayer = null;
    private Long lastMessagedTimeStamp = null;
    private static final Integer MAXIMUM_AGE_MINUTES = 10;

    public PrivateMessageAccessor(CorePlayer player) {
        super(player);
    }

    public Optional<ECPlayer> getLastMessagedPlayer() {
        if (this.lastMessagedTimeStamp == null || DateUtils.minutesSince(this.lastMessagedTimeStamp) > MAXIMUM_AGE_MINUTES) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.lastMessagedPlayer);
    }

    public void setLastMessagedPlayer(ECPlayer lastMessagedPlayer) {
        this.lastMessagedPlayer = lastMessagedPlayer;
        this.lastMessagedTimeStamp = System.currentTimeMillis();
    }
}

