/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.nickname;

import com.equestricraft.api.common.APIPlayerNicknameDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.nickname.NicknameSession;
import com.equestricraft.core.player.nickname.SimpleNickname;

public class APIPlayerNicknameDtoImpl
implements APIPlayerNicknameDto {
    private final CorePlayer player;
    @Service
    private static NicknameSession nicknameSession;

    public APIPlayerNicknameDtoImpl(CorePlayer player) {
        this.player = player;
    }

    @Override
    public String getValue() {
        return this.player.getNickname().map(n -> n.getTextItem().getText() + "&r").orElse(null);
    }

    @Override
    public String getBasic() {
        String nickname = this.getValue();
        if (nickname != null) {
            return ColorsHelper.stripColorsAndFormatting(nickname);
        }
        return null;
    }

    @Override
    public void setValue(String value) {
        nicknameSession.changePlayerNicknameNoCharge(this.player, new SimpleNickname(value));
    }

    public String toString() {
        return this.getValue();
    }
}

