/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.nickname;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.common.Argb;
import com.equestricraft.core.player.nickname.Nickname;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AdvancedNickname
extends Nickname {
    private static final String BOLD_DESIGNATOR = "B";
    private static final String ITALIC_DESIGNATOR = "I";
    private static final String UNDERLINE_DESIGNATOR = "U";
    private static final String STRIKETHROUGH_DESIGNATOR = "S";
    private static final String LETTER_START = "&";

    public AdvancedNickname(String rawValue) {
        super(rawValue);
    }

    @Override
    public TextItem getTextItem() {
        String[] parts;
        TextItem textItem = new TextItem();
        String stripped = this.rawValue.substring("[ADVANCED]".length());
        Optional<Styles> styles = this.getStyles(stripped);
        if (styles.isPresent()) {
            textItem.setBold(styles.get().bold());
            textItem.setItalic(styles.get().italic());
            textItem.setUnderline(styles.get().underline());
            textItem.setStrikethrough(styles.get().strikethrough());
        }
        for (String part : parts = stripped.split(LETTER_START)) {
            if (part.isEmpty() || part.contains("[")) continue;
            String hex = part.substring(0, 7);
            Argb argb = Argb.fromHexString(hex);
            String letter = part.substring(7);
            TextItem letterItem = new TextItem(letter);
            letterItem.setColor(argb);
            textItem.addChildItem(letterItem);
        }
        return textItem;
    }

    private Optional<Styles> getStyles(String string) {
        if (string.startsWith("[")) {
            int end = string.indexOf("]");
            String designators = string.substring(1, end);
            return Optional.of(new Styles(designators.contains(BOLD_DESIGNATOR), designators.contains(ITALIC_DESIGNATOR), designators.contains(UNDERLINE_DESIGNATOR), designators.contains(STRIKETHROUGH_DESIGNATOR)));
        }
        return Optional.empty();
    }

    @Override
    public boolean isPlain() {
        return false;
    }

    @Override
    public Nickname withoutColors() {
        return new AdvancedNickname(this.getColorStripped());
    }

    private record Styles(boolean bold, boolean italic, boolean underline, boolean strikethrough) {
    }

    public static class Builder {
        private final List<Letter> letters = new ArrayList<Letter>();
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private boolean strikethrough = false;

        private Builder() {
        }

        public Builder withAdvancedLetter(String letter, Argb color) {
            this.letters.add(new Letter(letter, color));
            return this;
        }

        public Builder withBold(boolean bold) {
            this.bold = bold;
            return this;
        }

        public Builder withItalic(boolean italic) {
            this.italic = italic;
            return this;
        }

        public Builder withUnderline(boolean underline) {
            this.underline = underline;
            return this;
        }

        public Builder withStrikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
            return this;
        }

        public AdvancedNickname complete() {
            String styleDesignator = this.encodeStyles();
            String encoded = this.encodeLetters();
            return new AdvancedNickname("[ADVANCED]" + styleDesignator + encoded);
        }

        private String encodeStyles() {
            if (this.bold || this.italic || this.underline || this.strikethrough) {
                Object styles = "";
                if (this.bold) {
                    styles = (String)styles + AdvancedNickname.BOLD_DESIGNATOR;
                }
                if (this.italic) {
                    styles = (String)styles + AdvancedNickname.ITALIC_DESIGNATOR;
                }
                if (this.underline) {
                    styles = (String)styles + AdvancedNickname.UNDERLINE_DESIGNATOR;
                }
                if (this.strikethrough) {
                    styles = (String)styles + AdvancedNickname.STRIKETHROUGH_DESIGNATOR;
                }
                return "[" + (String)styles + "]";
            }
            return "";
        }

        private String encodeLetters() {
            return this.letters.stream().map(l -> AdvancedNickname.LETTER_START + l.color().getHexValue() + l.letter()).collect(Collectors.joining());
        }

        public static Builder start() {
            return new Builder();
        }

        private record Letter(String letter, Argb color) {
        }
    }
}

