/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.nickname;

import com.equestricraft.base.text.TextItem;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.core.player.nickname.AdvancedNickname;
import com.equestricraft.core.player.nickname.SimpleNickname;
import java.util.Objects;

public abstract class Nickname {
    final String rawValue;
    static final String ADVANCED_PREFIX = "[ADVANCED]";

    Nickname(String rawValue) {
        this.rawValue = Objects.requireNonNull(rawValue);
    }

    public abstract TextItem getTextItem();

    public final String getColorStripped() {
        return ColorsHelper.stripColorsAndFormatting(this.getTextItem().toString());
    }

    public final String getRawValue() {
        return this.rawValue;
    }

    public abstract boolean isPlain();

    public final int getLetterCount() {
        return this.getColorStripped().length();
    }

    public abstract Nickname withoutColors();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Nickname nickname = (Nickname)o;
        return Objects.equals(this.rawValue, nickname.rawValue);
    }

    public int hashCode() {
        return Objects.hash(this.rawValue);
    }

    public String toString() {
        return this.getTextItem().toString();
    }

    public static Nickname createNickname(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (rawValue.startsWith(ADVANCED_PREFIX)) {
            return new AdvancedNickname(rawValue);
        }
        return new SimpleNickname(rawValue);
    }
}

