/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.nickname;

import com.equestricraft.base.database.TransactionManagement;
import com.equestricraft.common.DonatorLevel;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.nickname.Nickname;
import com.equestricraft.core.player.nickname.NicknameChangeException;
import com.equestricraft.core.player.nickname.NicknameSession;
import com.equestricraft.discord.DiscordPlayerNicknameUpdater;
import com.equestricraft.logging.Log;
import java.util.Optional;

@TransactionManagement
public class NicknameSessionImpl
implements NicknameSession {
    private final DiscordPlayerNicknameUpdater discordPlayerNicknameUpdater = new DiscordPlayerNicknameUpdater();
    private static final String LETTERS_REGEX = "^[a-zA-Z]+$";
    private static final Log log = Log.getLogger(NicknameSessionImpl.class.getName());

    @Override
    public void changePlayerNicknameWithCharge(ECPlayer player, Nickname newNickname) throws NicknameChangeException {
        int tokenBalance = this.retrievePlayersNicknameTokens(player);
        boolean shouldCharge = this.shouldBeCharged(player, newNickname);
        if (shouldCharge && tokenBalance <= 0) {
            throw new NicknameChangeException(I18n.getLabel("nickname.no-tokens-left"));
        }
        this.changePlayerNicknameNoCharge(player, newNickname);
        if (shouldCharge) {
            player.getCorePlayer().setNicknameTokens(--tokenBalance);
            player.getCorePlayer().save();
        }
        log.info("Player with internal ID {} has had their nickname changed to {}", (Object)player.getId(), (Object)newNickname);
    }

    private boolean shouldBeCharged(ECPlayer player, Nickname newNickname) {
        boolean hasUnlimitedChanges = player.getPermission().hasPermission("equestricraft.nickname.unlimited-changes") || player.getDonator().isAtLeastDonatorLevel(DonatorLevel.EQUESTRIAN_EMERALD);
        return !hasUnlimitedChanges && !this.isJustAddingColors(player, newNickname);
    }

    private boolean isJustAddingColors(ECPlayer player, Nickname newNickname) {
        Optional<Nickname> currentNickname = player.getNickname();
        if (currentNickname.isEmpty()) {
            return false;
        }
        if (!currentNickname.get().isPlain()) {
            return false;
        }
        return currentNickname.get().getColorStripped().equals(newNickname.getColorStripped());
    }

    @Override
    public void changePlayerNicknameNoCharge(ECPlayer player, Nickname newNickname) {
        if (newNickname.getRawValue().length() > 2000) {
            throw new IllegalArgumentException(I18n.getLabel("nickname.too-long", 2000));
        }
        if (!newNickname.getColorStripped().matches(LETTERS_REGEX)) {
            throw new IllegalArgumentException(I18n.getLabel("nickname.only-letters-allowed"));
        }
        if (newNickname.getLetterCount() > 25) {
            throw new IllegalArgumentException(I18n.getLabel("nickname.too-long-after-codes", 25));
        }
        if (!this.canUseFormattingCodes(player)) {
            newNickname = newNickname.withoutColors();
        }
        player.getCorePlayer().setNickname(newNickname);
        player.getCorePlayer().save();
        this.discordPlayerNicknameUpdater.syncPlayersNickname(player.getId());
    }

    @Override
    public int retrievePlayersNicknameTokens(ECPlayer player) {
        return player.getCorePlayer().getNicknameTokens();
    }

    @Override
    public boolean canChangeNickname(ECPlayer player) {
        int tokens = this.retrievePlayersNicknameTokens(player);
        if (tokens > 0) {
            return true;
        }
        if (player.getPermission().hasPermission("equestricraft.nickname.unlimited-changes")) {
            return true;
        }
        Optional<Nickname> currentNickname = player.getNickname();
        return currentNickname.map(Nickname::isPlain).orElse(false);
    }

    @Override
    public boolean canUseFormattingCodes(ECPlayer player) {
        return player.getPermission().hasPermission("equestricraft.nickname.formatting-codes") || player.getDonator().isAtLeastDonatorLevel(DonatorLevel.EQUESTRIAN_EMERALD);
    }

    @Override
    public void giveNicknameTokensToPlayer(ECPlayer player, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Must not be less than zero");
        }
        int tokenBalance = this.retrievePlayersNicknameTokens(player);
        if (amount == 0) {
            return;
        }
        player.getCorePlayer().setNicknameTokens(tokenBalance += amount);
        player.getCorePlayer().save();
    }
}

