/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.notification;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.player.notification.PlayerNotification;
import java.util.List;
import java.util.UUID;

public class PlayerNotificationDatabase
implements RepositoryDatasource<PlayerNotification, UUID> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_MESSAGE = "MESSAGE";

    @Override
    public void create(PlayerNotification playerNotification) {
        Query.insertInto("PLAYER_NOTIFICATION").columns(QueryColumn.column(COLUMN_ID, playerNotification.getId()), QueryColumn.column(COLUMN_PLAYER_ID, playerNotification.getPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, playerNotification.getTimeStamp()), QueryColumn.column(COLUMN_MESSAGE, playerNotification.getMessage())).execute();
    }

    @Override
    public List<PlayerNotification> retrieveAll() {
        return Query.selectAllFrom("PLAYER_NOTIFICATION").getList(this::getFromResultRow);
    }

    @Override
    public void deleteByKey(UUID id) {
        Query.deleteFrom("PLAYER_NOTIFICATION").where(QueryColumn.column(COLUMN_ID, id)).execute();
    }

    private PlayerNotification getFromResultRow(ResultRow row) {
        UUID id = row.getUuid(COLUMN_ID);
        int playerId = row.getInt(COLUMN_PLAYER_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        String message = row.getString(COLUMN_MESSAGE);
        return new PlayerNotification(id, playerId, timeStamp, message);
    }
}

