/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.notification;

import com.equestricraft.base.pagination.Pagination;
import com.equestricraft.base.pagination.SortDirection;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.notification.PlayerNotificationPage;
import com.equestricraft.core.player.notification.PlayerNotificationPageService;
import com.equestricraft.core.player.notification.PlayerNotificationRecord;
import com.equestricraft.core.player.notification.PlayerNotificationSession;
import java.util.Comparator;
import java.util.List;

public class PlayerNotificationPageServiceImpl
extends Pagination<PlayerNotificationRecord, PlayerNotificationPage, Object, String>
implements PlayerNotificationPageService {
    @Service
    private PlayerNotificationSession playerNotificationSession;
    private static final int MAXIMUM_PER_PAGE = 8;

    @Override
    public PlayerNotificationPage retrievePlayerNotificationPage(ECPlayer player, int pageNumber, SortDirection sortDirection, String textSearch) {
        List<PlayerNotificationRecord> notifications = this.playerNotificationSession.retrievePlayersNotifications(player);
        return (PlayerNotificationPage)this.paginate(notifications, pageNumber, sortDirection, null, textSearch.toLowerCase());
    }

    @Override
    protected int getMaximumPerPage() {
        return 8;
    }

    @Override
    protected boolean filter(PlayerNotificationRecord item, String filterObject) {
        return item.message().toLowerCase().contains(filterObject);
    }

    @Override
    protected Comparator<PlayerNotificationRecord> compare(Object sortOrderObject) {
        return Comparator.comparing(PlayerNotificationRecord::hoursSince);
    }

    @Override
    protected PlayerNotificationPage buildPage(List<PlayerNotificationRecord> items, int pageNumber, int totalPages, SortDirection sortDirection, Object sortObject, String filterObject) {
        return new PlayerNotificationPage(items, pageNumber, totalPages, sortDirection, sortObject, filterObject);
    }
}

