/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.notification;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.notification.PlayerNotificationService;
import com.equestricraft.core.player.notification.PlayerNotificationSession;
import com.equestricraft.logging.Log;

public class PlayerNotificationServiceImpl
implements PlayerNotificationService {
    @Service
    private PlayerNotificationSession playerNotificationSession;
    private static final Log log = Log.getLogger(PlayerNotificationServiceImpl.class.getName());

    @Override
    public boolean notifyPlayer(ECPlayer player, String message) {
        boolean wasOnline = player.sendMessage(message);
        if (!wasOnline) {
            log.info("Player {} is not online so adding a notification for when they next log on", (Object)player.getIgn());
            this.playerNotificationSession.addNotification(player, message);
            return false;
        }
        if (player.getAfk().isAFk()) {
            log.info("Player {} is AFK so adding a notification for when they next log on", (Object)player.getIgn());
            this.playerNotificationSession.addNotification(player, message);
            return false;
        }
        return true;
    }
}

