/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.player.notification;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.notification.PlayerNotification;
import com.equestricraft.core.player.notification.PlayerNotificationRecord;
import com.equestricraft.core.player.notification.PlayerNotificationRepository;
import com.equestricraft.core.player.notification.PlayerNotificationSession;
import com.equestricraft.core.player.notification.PlayerNotificationUpdateEvent;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PlayerNotificationSessionImpl
implements PlayerNotificationSession {
    @Service
    private PlayerNotificationRepository playerNotificationRepository;

    @Override
    public void addNotification(ECPlayer player, String message) {
        PlayerNotification newNotification = new PlayerNotification();
        newNotification.setId(UUID.randomUUID());
        newNotification.setPlayerId(player.getId());
        newNotification.setTimeStamp(System.currentTimeMillis());
        newNotification.setMessage(message);
        this.playerNotificationRepository.add(newNotification);
        this.fireNotificationChange(player);
    }

    @Override
    public boolean hasNotificationsSince(ECPlayer player, Date time) {
        List<PlayerNotification> notifications = this.playerNotificationRepository.findByPlayer(player.getId());
        return notifications.stream().anyMatch(n -> n.getTimeStamp() >= time.getTime());
    }

    @Override
    public List<PlayerNotificationRecord> retrievePlayersNotifications(ECPlayer player) {
        List<PlayerNotification> notifications = this.playerNotificationRepository.findByPlayer(player.getId());
        return notifications.stream().map(this::buildRecord).toList();
    }

    private PlayerNotificationRecord buildRecord(PlayerNotification playerNotification) {
        return new PlayerNotificationRecord(playerNotification.getId(), DateUtils.hoursSince(playerNotification.getTimeStamp()), playerNotification.getMessage());
    }

    @Override
    public void clearAllNotificationsForPlayer(ECPlayer player) {
        List<PlayerNotification> notifications = this.playerNotificationRepository.findByPlayer(player.getId());
        notifications.forEach(this.playerNotificationRepository::remove);
        this.fireNotificationChange(player);
    }

    private void fireNotificationChange(ECPlayer player) {
        int count = this.getPlayersNotificationCount(player);
        PlayerNotificationUpdateEvent event = new PlayerNotificationUpdateEvent(player, count);
        ECEventBus.post(event);
    }

    @Override
    public int getPlayersNotificationCount(ECPlayer player) {
        List<PlayerNotification> notifications = this.playerNotificationRepository.findByPlayer(player.getId());
        return notifications.size();
    }
}

